/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.s7;

import javaforce.BE;

public class S7Header {
    public byte id = (byte)50;
    public byte rosctr = 1;
    public short res;
    public short pdu_ref;
    public short param_length;
    public short data_length;

    public int size() {
        switch (this.rosctr) {
            case 1: {
                return 10;
            }
            case 3: {
                return 12;
            }
        }
        return 0;
    }

    public void write(byte[] data, int offset, short _param_length, short _data_length) {
        this.pdu_ref = (short)1280;
        this.param_length = _param_length;
        this.data_length = _data_length;
        data[offset++] = this.id;
        data[offset++] = this.rosctr;
        BE.setuint16(data, offset, this.res);
        BE.setuint16(data, offset += 2, this.pdu_ref);
        BE.setuint16(data, offset += 2, this.param_length);
        BE.setuint16(data, offset += 2, this.data_length);
        offset += 2;
    }

    public void read(byte[] data, int offset) throws Exception {
        this.id = data[offset++];
        this.rosctr = data[offset++];
        this.res = (short)BE.getuint16(data, offset);
        this.pdu_ref = (short)BE.getuint16(data, offset += 2);
        this.param_length = (short)BE.getuint16(data, offset += 2);
        this.data_length = (short)BE.getuint16(data, offset += 2);
        offset += 2;
        if (this.rosctr == 3) {
            // empty if block
        }
    }
}

