/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.media.MediaAudioDecoder;
import javaforce.media.MediaFormat;
import javaforce.media.MediaIO;
import javaforce.media.MediaVideoDecoder;
import javaforce.voip.CodecInfo;
import javaforce.voip.Packet;

public class MediaInput
extends MediaFormat {
    private Packet packet;

    private static native long nopenFile(String var0, String var1);

    public boolean open(String file, String format) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaInput.nopenFile(file, format);
        return this.ctx != 0L;
    }

    private static native long nopenIO(MediaIO var0);

    public boolean open(MediaIO io) {
        if (this.ctx != 0L) {
            return false;
        }
        this.ctx = MediaInput.nopenIO(io);
        return this.ctx != 0L;
    }

    private static native long ngetDuration(long var0);

    private static native int ngetVideoWidth(long var0);

    private static native int ngetVideoHeight(long var0);

    private static native float ngetVideoFrameRate(long var0);

    private static native int ngetVideoKeyFrameInterval(long var0);

    private static native int ngetAudioChannels(long var0);

    private static native int ngetAudioSampleRate(long var0);

    public CodecInfo getCodecInfo() {
        CodecInfo info = new CodecInfo();
        info.duration = MediaInput.ngetDuration(this.ctx);
        if (this.getVideoStream() != -1) {
            info.width = MediaInput.ngetVideoWidth(this.ctx);
            info.height = MediaInput.ngetVideoHeight(this.ctx);
            info.fps = MediaInput.ngetVideoFrameRate(this.ctx);
            info.keyFrameInterval = MediaInput.ngetVideoKeyFrameInterval(this.ctx);
            info.video_bit_rate = this.getVideoBitRate();
            info.video_codec = this.getVideoCodecID();
            info.video_stream = this.getVideoStream();
        }
        if (this.getAudioStream() != -1) {
            info.chs = MediaInput.ngetAudioChannels(this.ctx);
            info.freq = MediaInput.ngetAudioSampleRate(this.ctx);
            info.bits = 16;
            info.audio_bit_rate = this.getAudioBitRate();
            info.audio_codec = this.getAudioCodecID();
            info.audio_stream = this.getAudioStream();
        }
        return info;
    }

    private static native boolean nclose(long var0);

    public boolean close() {
        if (this.ctx == 0L) {
            return false;
        }
        boolean res = MediaInput.nclose(this.ctx);
        this.ctx = 0L;
        return res;
    }

    private static native boolean nopenvideo(long var0, int var2, int var3);

    public MediaVideoDecoder createVideoDecoder(int width, int height) {
        if (!MediaInput.nopenvideo(this.ctx, width, height)) {
            return null;
        }
        MediaVideoDecoder decoder = new MediaVideoDecoder(this);
        decoder.setStream(this.getVideoStream());
        return decoder;
    }

    public MediaVideoDecoder createVideoDecoder() {
        return this.createVideoDecoder(-1, -1);
    }

    private static native boolean nopenaudio(long var0, int var2, int var3);

    public MediaAudioDecoder createAudioDecoder(int chs, int freq) {
        if (!MediaInput.nopenaudio(this.ctx, chs, freq)) {
            return null;
        }
        MediaAudioDecoder decoder = new MediaAudioDecoder(this);
        decoder.setStream(this.getAudioStream());
        return decoder;
    }

    public MediaAudioDecoder createAudioDecoder() {
        return this.createAudioDecoder(-1, -1);
    }

    private static native int nread(long var0);

    private static native boolean ngetPacketKeyFrame(long var0);

    private static native int ngetPacketData(long var0, byte[] var2, int var3, int var4);

    public Packet readPacket() {
        if (this.ctx == 0L) {
            return null;
        }
        if (this.packet == null) {
            this.packet = new Packet();
            this.packet.data = new byte[65536];
        }
        int length = MediaInput.nread(this.ctx);
        while (this.packet.data.length < length) {
            this.packet.data = new byte[this.packet.data.length << 1];
        }
        this.packet.length = length;
        this.packet.keyFrame = MediaInput.ngetPacketKeyFrame(this.ctx);
        this.packet.stream = MediaInput.ngetPacketData(this.ctx, this.packet.data, 0, length);
        return this.packet;
    }

    private native boolean nseek(long var1, long var3);

    public boolean seek(long seconds) {
        return this.nseek(this.ctx, seconds);
    }
}

