/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javaforce.LDAP;
import javaforce.awt.JFAWT;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class TestLDAP
extends JFrame {
    private JTextField attr;
    private JTextField dn;
    private JTextField domain;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JComboBox<String> keyType;
    private JTextField keyValue;
    private JButton login;
    private JPasswordField password;
    private JButton query;
    private JTextField server;
    private JTextField username;

    public TestLDAP() {
        this.initComponents();
        JFAWT.centerWindow(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.username = new JTextField();
        this.jLabel2 = new JLabel();
        this.password = new JPasswordField();
        this.login = new JButton();
        this.jLabel3 = new JLabel();
        this.server = new JTextField();
        this.domain = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.attr = new JTextField();
        this.query = new JButton();
        this.keyValue = new JTextField();
        this.jLabel7 = new JLabel();
        this.dn = new JTextField();
        this.keyType = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("LDAP Test");
        this.jLabel1.setText("Username");
        this.jLabel2.setText("Password");
        this.login.setText("Login");
        this.login.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestLDAP.this.loginActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Server");
        this.jLabel4.setText("Domain");
        this.jLabel5.setText("Attribute(s)");
        this.attr.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestLDAP.this.attrActionPerformed(evt);
            }
        });
        this.query.setText("Query");
        this.query.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestLDAP.this.queryActionPerformed(evt);
            }
        });
        this.jLabel7.setText("DN");
        this.keyType.setModel(new DefaultComboBoxModel<String>(new String[]{"SAMAccountName", "mail"}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel7).addComponent(this.jLabel5).addComponent(this.keyType, -2, -1, -2)).addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.keyValue, GroupLayout.Alignment.LEADING, -1, 225, Short.MAX_VALUE).addComponent(this.dn, GroupLayout.Alignment.LEADING).addComponent(this.domain, GroupLayout.Alignment.LEADING).addComponent(this.username, GroupLayout.Alignment.LEADING).addComponent(this.password, GroupLayout.Alignment.LEADING).addComponent(this.server, GroupLayout.Alignment.LEADING).addComponent(this.attr)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.login).addComponent(this.query)).addContainerGap(8, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.domain, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.username, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.password, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.server, -2, -1, -2).addComponent(this.login)).addGap(42, 42, 42).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.dn, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyValue, -2, -1, -2).addComponent(this.keyType, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.attr, -2, -1, -2).addComponent(this.query)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void loginActionPerformed(ActionEvent evt) {
        this.testLogin();
    }

    private void attrActionPerformed(ActionEvent evt) {
    }

    private void queryActionPerformed(ActionEvent evt) {
        this.query();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TestLDAP().setVisible(true);
            }
        });
    }

    public void testLogin() {
        String user = this.username.getText();
        String pass = new String(this.password.getPassword());
        String svr = this.server.getText();
        String dom = this.domain.getText();
        try {
            LDAP ldap = new LDAP();
            if (!ldap.login(svr, dom, user, pass)) {
                throw ldap.lastException;
            }
            JFAWT.showMessage("LDAP", "Login Accepted");
        }
        catch (Exception e) {
            e.printStackTrace();
            JFAWT.showMessage("LDAP", "Login Denied");
        }
    }

    public void query() {
        String user = this.username.getText();
        String pass = new String(this.password.getPassword());
        String svr = this.server.getText();
        String dom = this.domain.getText();
        String dif_dn = this.dn.getText();
        String key_type = this.keyType.getSelectedItem().toString();
        String key_value = this.keyValue.getText();
        String atr = this.attr.getText();
        try {
            LDAP ldap = new LDAP();
            if (!ldap.login(svr, dom, user, pass)) {
                throw ldap.lastException;
            }
            String[] atrs = atr.split("[,]");
            String[] res = ldap.getAttributes(dif_dn, key_type + "=" + key_value, atrs);
            if (res == null) {
                JFAWT.showMessage("LDAP", "null result");
                return;
            }
            StringBuilder values = new StringBuilder();
            for (int a = 0; a < res.length; ++a) {
                values.append(res[a]);
                values.append("\r\n");
            }
            JFAWT.showMessage("Results", values.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            JFAWT.showMessage("LDAP", "Login Denied");
        }
    }
}

