/*
 * Decompiled with CFR 0.152.
 */
package javaforce.tests;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Random;
import javaforce.JF;
import javaforce.JFLog;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TestSSL {
    public static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static void main(String[] args) {
        try {
            TestSSL.testTcp();
            TestSSL.testUdp();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void _log(String side, boolean client, String msg) {
        JFLog.log(side + ":" + (client ? "client" : "server") + ":" + msg);
    }

    public static void initCtx(SSLContext ctx) {
        try {
            char[] passphrase = "password".toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream("testssl.key"), passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            ctx.init(kmf.getKeyManagers(), trustAllCerts, new SecureRandom());
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public static void testTcp() throws Exception {
        JFLog.log("Starting TCP test");
        TcpServer srv = new TcpServer();
        srv.start();
        JF.sleep(500);
        TcpClient clt = new TcpClient();
        clt.start();
        srv.join();
        clt.join();
    }

    public static void testUdp() throws Exception {
        JFLog.log("Starting UDP test");
        UdpServer srv = new UdpServer();
        srv.start();
        JF.sleep(500);
        UdpClient clt = new UdpClient();
        clt.start();
        srv.join();
        clt.join();
    }

    public static class TcpServer
    extends Thread {
        public ServerSocket ss;
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public SSLContext ctx;
        public SSLSessionContext sessctx;
        public SSLEngine ssl;

        @Override
        public void run() {
            try {
                JFLog.log("Server Listening on port 1111");
                this.ss = new ServerSocket(1111);
                this.s = this.ss.accept();
                JFLog.log("Server received client");
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                this.ctx = SSLContext.getInstance("TLSv1.2");
                TestSSL.initCtx(this.ctx);
                this.ssl = this.ctx.createSSLEngine();
                this.ssl.setUseClientMode(false);
                this.sessctx = this.ctx.getServerSessionContext();
                TcpReader reader = new TcpReader();
                reader.is = this.is;
                reader.ssl = this.ssl;
                TcpWriter writer = new TcpWriter();
                writer.os = this.os;
                writer.ssl = this.ssl;
                reader.start();
                writer.start();
                reader.join();
                writer.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class TcpClient
    extends Thread {
        public Socket s;
        public InputStream is;
        public OutputStream os;
        public SSLContext ctx;
        public SSLSessionContext sessctx;
        public SSLEngine ssl;

        @Override
        public void run() {
            try {
                JFLog.log("Client connecting to server");
                this.s = new Socket("localhost", 1111);
                JFLog.log("Client connected");
                this.is = this.s.getInputStream();
                this.os = this.s.getOutputStream();
                this.ctx = SSLContext.getInstance("TLSv1.2");
                this.ctx.init(null, trustAllCerts, new SecureRandom());
                this.ssl = this.ctx.createSSLEngine("localhost", 1111);
                this.ssl.setUseClientMode(true);
                this.sessctx = this.ctx.getClientSessionContext();
                TcpReader reader = new TcpReader();
                reader.is = this.is;
                reader.ssl = this.ssl;
                reader.client = true;
                TcpWriter writer = new TcpWriter();
                writer.os = this.os;
                writer.ssl = this.ssl;
                writer.client = true;
                reader.start();
                writer.start();
                reader.join();
                writer.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class UdpServer
    extends Thread {
        public DatagramSocket ds;
        public SSLContext ctx;
        public SSLSessionContext sessctx;
        public SSLEngine ssl;

        @Override
        public void run() {
            try {
                JFLog.log("Server binding on port 1111");
                this.ds = new DatagramSocket(1111);
                this.ctx = SSLContext.getInstance("DTLS");
                TestSSL.initCtx(this.ctx);
                this.ssl = this.ctx.createSSLEngine();
                this.ssl.setUseClientMode(false);
                this.sessctx = this.ctx.getServerSessionContext();
                UdpHandshake handshake = new UdpHandshake();
                handshake.ds = this.ds;
                handshake.ssl = this.ssl;
                handshake.client = false;
                handshake.start();
                handshake.join();
                UdpReader reader = new UdpReader();
                reader.ds = this.ds;
                reader.ssl = this.ssl;
                UdpWriter writer = new UdpWriter();
                writer.ds = this.ds;
                writer.ssl = this.ssl;
                writer.reader = reader;
                reader.start();
                writer.start();
                reader.join();
                writer.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class UdpClient
    extends Thread {
        public DatagramSocket ds;
        public SSLContext ctx;
        public SSLSessionContext sessctx;
        public SSLEngine ssl;

        @Override
        public void run() {
            try {
                JFLog.log("Client binding on port 2222");
                this.ds = new DatagramSocket(2222);
                this.ctx = SSLContext.getInstance("DTLS");
                this.ctx.init(null, trustAllCerts, new SecureRandom());
                this.ssl = this.ctx.createSSLEngine("localhost", 2222);
                this.ssl.setUseClientMode(true);
                this.sessctx = this.ctx.getClientSessionContext();
                UdpHandshake handshake = new UdpHandshake();
                handshake.ds = this.ds;
                handshake.ssl = this.ssl;
                handshake.client = true;
                handshake.start();
                handshake.join();
                UdpReader reader = new UdpReader();
                reader.ds = this.ds;
                reader.ssl = this.ssl;
                reader.client = true;
                UdpWriter writer = new UdpWriter();
                writer.ds = this.ds;
                writer.ssl = this.ssl;
                writer.client = true;
                writer.reader = reader;
                reader.start();
                writer.start();
                reader.join();
                writer.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class UdpWriter
    extends Thread {
        public DatagramSocket ds;
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer output;
        public ByteBuffer transfer;
        public UdpReader reader;

        public void log(String msg) {
            TestSSL._log("writer", this.client, msg);
        }

        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                byte[] tmp = new byte[1024];
                Random r = new Random();
                r.nextBytes(tmp);
                this.output = ByteBuffer.wrap(tmp);
                this.transfer = ByteBuffer.allocateDirect(sess.getPacketBufferSize());
                int total = 0;
                while (true) {
                    SSLEngineResult res = this.ssl.wrap(this.output, this.transfer);
                    int consumed = res.bytesConsumed();
                    int produced = res.bytesProduced();
                    if (consumed == 0 && produced == 0) {
                        JF.sleep(10);
                        continue;
                    }
                    this.transfer.flip();
                    if (produced > 0) {
                        byte[] out = new byte[produced];
                        this.transfer.get(out);
                        DatagramPacket dp = new DatagramPacket(out, out.length);
                        dp.setSocketAddress(new InetSocketAddress(InetAddress.getByName("localhost"), this.client ? 1111 : 2222));
                        this.ds.send(dp);
                    }
                    if (consumed > 0 && (total += consumed) == 1024) break;
                    this.output.flip();
                    this.output.compact();
                    this.transfer.compact();
                }
                this.log("done");
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class UdpReader
    extends Thread {
        public DatagramSocket ds;
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer transfer;
        public ByteBuffer input;

        public void log(String msg) {
            TestSSL._log("reader", this.client, msg);
        }

        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                int maxAppSize = sess.getApplicationBufferSize();
                int maxPackSize = sess.getPacketBufferSize();
                this.input = ByteBuffer.allocate(maxAppSize + 50);
                this.transfer = ByteBuffer.allocateDirect(maxPackSize);
                int total = 0;
                do {
                    DatagramPacket dp = new DatagramPacket(new byte[maxPackSize], maxPackSize);
                    this.ds.receive(dp);
                    int length = dp.getLength();
                    if (length > 0) {
                        int maxRead = this.transfer.remaining();
                        if (length > maxRead) {
                            length = maxRead;
                        }
                        this.log("rawread:" + length);
                        this.transfer.put(dp.getData(), 0, length);
                    }
                    this.transfer.flip();
                    SSLEngineResult res = this.ssl.unwrap(this.transfer, this.input);
                    int consumed = res.bytesConsumed();
                    int produced = res.bytesProduced();
                    this.input.flip();
                    if (produced > 0) {
                        byte[] tmp = new byte[produced];
                        this.input.get(tmp);
                        if ((total += produced) == 1024) break;
                    }
                    this.transfer.compact();
                    this.input.compact();
                } while (total != 1024);
                this.log("done");
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class UdpHandshake
    extends Thread {
        public DatagramSocket ds;
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer intransfer;
        public ByteBuffer outtransfer;
        public ByteBuffer input;
        public ByteBuffer output;

        public void log(String msg) {
            TestSSL._log("handshake", this.client, msg);
        }

        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                int maxAppSize = sess.getApplicationBufferSize();
                int maxPackSize = sess.getPacketBufferSize();
                this.input = ByteBuffer.allocate(maxAppSize + 50);
                this.output = ByteBuffer.allocate(maxAppSize + 50);
                this.intransfer = ByteBuffer.allocateDirect(maxPackSize * 2);
                this.outtransfer = ByteBuffer.allocateDirect(maxPackSize * 2);
                block8: while (true) {
                    this.log("status=" + String.valueOf((Object)this.ssl.getHandshakeStatus()));
                    SSLEngineResult.HandshakeStatus status = this.ssl.getHandshakeStatus();
                    if (status == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                        status = this.client ? SSLEngineResult.HandshakeStatus.NEED_WRAP : SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                    }
                    switch (status) {
                        case NEED_TASK: {
                            Runnable runnable;
                            while ((runnable = this.ssl.getDelegatedTask()) != null) {
                                runnable.run();
                            }
                            continue block8;
                        }
                        case NEED_WRAP: {
                            DatagramPacket dp;
                            SSLEngineResult res = this.ssl.wrap(this.output, this.outtransfer);
                            if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                this.log("done");
                                return;
                            }
                            int consumed = res.bytesConsumed();
                            int produced = res.bytesProduced();
                            if (produced > 0) {
                                this.log("rawwrite:" + produced);
                                byte[] out = new byte[produced];
                                this.outtransfer.flip();
                                if (this.outtransfer.remaining() != produced) {
                                    throw new Exception("transfer.remaining() != produced");
                                }
                                this.outtransfer.get(out);
                                dp = new DatagramPacket(out, out.length);
                                dp.setSocketAddress(new InetSocketAddress(InetAddress.getByName("localhost"), this.client ? 1111 : 2222));
                                this.ds.send(dp);
                            }
                            this.outtransfer.compact();
                            this.output.compact();
                            break;
                        }
                        case NEED_UNWRAP: {
                            DatagramPacket dp = new DatagramPacket(new byte[maxPackSize], maxPackSize);
                            this.ds.receive(dp);
                            int length = dp.getLength();
                            if (length > 0) {
                                this.log("rawread:" + length);
                                this.intransfer.put(dp.getData(), 0, length);
                            }
                            this.intransfer.flip();
                            SSLEngineResult res = this.ssl.unwrap(this.intransfer, this.input);
                            if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                this.log("done");
                                return;
                            }
                            int consumed = res.bytesConsumed();
                            int produced = res.bytesProduced();
                            this.intransfer.compact();
                            this.input.compact();
                            break;
                        }
                        case NEED_UNWRAP_AGAIN: {
                            this.intransfer.limit(0);
                            SSLEngineResult res = this.ssl.unwrap(this.intransfer, this.input);
                            if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                                this.log("done");
                                return;
                            }
                            int consumed = res.bytesConsumed();
                            int produced = res.bytesProduced();
                            this.intransfer.compact();
                            this.input.compact();
                        }
                    }
                }
            }
            catch (Exception e) {
                JFLog.log(e);
                return;
            }
        }
    }

    public static class TcpWriter
    extends Thread {
        public OutputStream os;
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer output;
        public ByteBuffer transfer;

        public void log(String msg) {
            TestSSL._log("writer", this.client, msg);
        }

        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                byte[] tmp = new byte[1024];
                Random r = new Random();
                r.nextBytes(tmp);
                this.output = ByteBuffer.wrap(tmp);
                this.transfer = ByteBuffer.allocateDirect(sess.getPacketBufferSize());
                int total = 0;
                while (true) {
                    SSLEngineResult res;
                    if ((res = this.ssl.wrap(this.output, this.transfer)).getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        Runnable runnable;
                        while ((runnable = this.ssl.getDelegatedTask()) != null) {
                            runnable.run();
                        }
                    }
                    int consumed = res.bytesConsumed();
                    int produced = res.bytesProduced();
                    if (consumed == 0 && produced == 0) {
                        JF.sleep(10);
                        continue;
                    }
                    if (produced > 0) {
                        this.log("rawwrite:" + produced);
                        byte[] out = new byte[produced];
                        this.transfer.flip();
                        if (this.transfer.remaining() != produced) {
                            throw new Exception("transfer.remaining() != produced");
                        }
                        this.transfer.get(out);
                        this.os.write(out);
                    }
                    if (consumed > 0 && (total += consumed) == 1024) break;
                    this.output.flip();
                    this.output.compact();
                    this.transfer.compact();
                }
                this.log("done");
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }

    public static class TcpReader
    extends Thread {
        public InputStream is;
        public SSLEngine ssl;
        public boolean client;
        public ByteBuffer transfer;
        public ByteBuffer input;

        public void log(String msg) {
            TestSSL._log("reader", this.client, msg);
        }

        @Override
        public void run() {
            try {
                SSLSession sess = this.ssl.getSession();
                int maxAppSize = sess.getApplicationBufferSize();
                int maxPackSize = sess.getPacketBufferSize();
                this.input = ByteBuffer.allocate(maxAppSize + 50);
                this.transfer = ByteBuffer.allocateDirect(maxPackSize);
                int total = 0;
                while (true) {
                    int produced;
                    int avail;
                    if ((avail = this.is.available()) > 0) {
                        byte[] tmp;
                        int read;
                        int maxRead = this.transfer.remaining();
                        if (avail > maxRead) {
                            avail = maxRead;
                        }
                        if ((read = this.is.read(tmp = new byte[avail])) == -1) break;
                        this.log("rawread:" + read);
                        this.transfer.put(tmp);
                    }
                    if (this.transfer.position() == 0) continue;
                    this.transfer.flip();
                    SSLEngineResult res = this.ssl.unwrap(this.transfer, this.input);
                    if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                        Runnable runnable;
                        while ((runnable = this.ssl.getDelegatedTask()) != null) {
                            runnable.run();
                        }
                    }
                    if ((produced = res.bytesProduced()) > 0) {
                        byte[] tmp = new byte[produced];
                        this.input.flip();
                        if (this.input.remaining() != produced) {
                            throw new Exception("input.remaining() != produced");
                        }
                        this.input.get(tmp);
                        if ((total += produced) == 1024) break;
                    }
                    this.transfer.compact();
                    this.input.compact();
                }
                this.log("done");
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }
    }
}

