/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import javaforce.webui.Button;
import javaforce.webui.Component;
import javaforce.webui.Container;
import javaforce.webui.event.Click;
import javaforce.webui.event.MouseEvent;

public class MediaComponent
extends Container {
    private String tag;
    private String src;
    private int state;
    private Button button_play;
    public static final int STATE_UNINIT = 0;
    public static final int STATE_STOP = 1;
    public static final int STATE_PLAY = 2;
    public static final int STATE_PAUSE = 3;

    public MediaComponent(String tag) {
        this.tag = tag;
        this.addEvent("onplay", "media_onplay(this);");
        this.addEvent("onstop", "media_onstop(this);");
        this.addEvent("onpause", "media_onpause(this);");
        this.addEvent("onseeking", "console.log('Media.seeking:readyState=' + this.readyState);");
        this.addEvent("onstaled", "console.log('Media.staled:readyState=' + this.readyState);");
        this.addEvent("onsuspend", "console.log('Media.suspend:readyState=' + this.readyState);");
        this.addEvent("onwaiting", "console.log('Media.waiting:readyState=' + this.readyState);");
        this.setStyle("position", "absolute");
        this.setStyle("left", "0px");
        this.setStyle("top", "0px");
        this.button_play = new Button("Play");
        this.button_play.addClickListener(new Click(){

            @Override
            public void onClick(MouseEvent me, Component comp) {
                MediaComponent.this.dispatchEvent("action", null);
            }
        });
        this.add(this.button_play);
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div id='" + this.getID() + "s1' style='display: inline-block; position: relative;");
        if (this.width != 0) {
            sb.append(" width:" + this.width + ";");
        }
        if (this.height != 0) {
            sb.append(" height:" + this.height + ";");
        }
        sb.append("'>");
        sb.append("<");
        sb.append(this.tag);
        sb.append(this.getAttrs());
        if (this.src != null) {
            sb.append(" src='" + this.src + "'");
        }
        sb.append(">");
        sb.append("</");
        sb.append(this.tag);
        sb.append(">");
        sb.append("<table id='" + this.getID() + "s2' style='position:absolute; left:0px; top:0px; width: 100%; height: 100%; background-color: grey;'>\n<tr height=50%></tr>\n<tr>\n<td width=50%></td>\n<td>\n" + this.button_play.html() + "</td>\n<td width=50%></td>\n</tr>\n<tr height=50%></tr></table>");
        sb.append("</div>");
        return sb.toString();
    }

    public void setSource(String url) {
        this.src = url;
    }

    public void setLiveSource(String codecs) {
        this.sendEvent("media_set_live_source", new String[]{"codecs=" + codecs});
    }

    public void setCapture(boolean doVideo, boolean doAudio) {
        this.sendEvent("media_set_capture", new String[]{"audio=" + doAudio, "video=" + doVideo});
    }

    public void play() {
        this.sendEvent("media_play", null);
        this.state = 2;
    }

    public void pause() {
        this.sendEvent("media_pause", null);
        this.state = 3;
    }

    public void stop() {
        this.sendEvent("media_stop", null);
        this.state = 1;
    }

    public void seek(double time) {
        this.sendEvent("media_seek", new String[]{"time=" + String.format("%.3f", time)});
    }

    @Override
    public void onEvent(String event, String[] args) {
        switch (event) {
            case "onplay": {
                this.onplay();
                break;
            }
            case "onpause": {
                this.onpause();
                break;
            }
            case "onstop": {
                this.onstop();
            }
        }
    }

    private void onplay() {
        this.state = 2;
        this.onChanged(null);
    }

    private void onpause() {
        this.state = 3;
        this.onChanged(null);
    }

    private void onstop() {
        this.state = 1;
        this.onChanged(null);
    }

    public boolean isPlaying() {
        return this.state == 2;
    }
}

