package javaforce.awt;

/** View JF Log File(s)
 *
 * Views all registered JFLog files.
 * Can view rotated files as well.
 *
 * @author pquiring
 */

import java.io.*;
import java.util.*;

import javaforce.*;

public class ViewJFLog extends javax.swing.JDialog {

  /**
   * Creates new form ViewLog
   */
  public ViewJFLog() {
    super((javax.swing.JFrame)null, true);
    initComponents();
    init();
  }

  private void init() {
    JFAWT.centerWindow(this);
    ids.clear();
    logFile.removeAllItems();
    int[] _ids = JFLog.getIDs();
    for(int id : _ids) {
      String name = JFLog.getLogFileName(id);
      ids.add(id);
      logFile.addItem(name);
    }
    historyFile.removeAllItems();
  }

  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    close = new javax.swing.JButton();
    jScrollPane1 = new javax.swing.JScrollPane();
    txt = new javax.swing.JTextArea();
    jLabel1 = new javax.swing.JLabel();
    logFile = new javax.swing.JComboBox<>();
    jLabel2 = new javax.swing.JLabel();
    historyFile = new javax.swing.JComboBox<>();

    setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
    addWindowListener(new java.awt.event.WindowAdapter() {
      public void windowClosing(java.awt.event.WindowEvent evt) {
        formWindowClosing(evt);
      }
    });

    close.setText("Close");
    close.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        closeActionPerformed(evt);
      }
    });

    txt.setEditable(false);
    txt.setColumns(20);
    txt.setRows(5);
    jScrollPane1.setViewportView(txt);

    jLabel1.setText("Log File");

    logFile.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(java.awt.event.ItemEvent evt) {
        logFileItemStateChanged(evt);
      }
    });

    jLabel2.setText("Rotation");

    historyFile.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(java.awt.event.ItemEvent evt) {
        historyFileItemStateChanged(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
          .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addGap(0, 0, Short.MAX_VALUE)
            .addComponent(close))
          .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 498, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(logFile, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
          .addGroup(layout.createSequentialGroup()
            .addComponent(jLabel2)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(historyFile, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel1)
          .addComponent(logFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jLabel2)
          .addComponent(historyFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 361, Short.MAX_VALUE)
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(close)
        .addContainerGap())
    );

    pack();
  }// </editor-fold>//GEN-END:initComponents

  private void closeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeActionPerformed
    isClosed = true;
    dispose();
  }//GEN-LAST:event_closeActionPerformed

  private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    isClosed = true;
  }//GEN-LAST:event_formWindowClosing

  private void logFileItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_logFileItemStateChanged
    loadLog();
  }//GEN-LAST:event_logFileItemStateChanged

  private void historyFileItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_historyFileItemStateChanged
    loadHistory();
  }//GEN-LAST:event_historyFileItemStateChanged

  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    final String file = args[0];
    java.awt.EventQueue.invokeLater(new Runnable() {
      public void run() {
        new ViewLog(new File(file)).setVisible(true);
      }
    });
  }

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton close;
  private javax.swing.JComboBox<String> historyFile;
  private javax.swing.JLabel jLabel1;
  private javax.swing.JLabel jLabel2;
  private javax.swing.JScrollPane jScrollPane1;
  private javax.swing.JComboBox<String> logFile;
  private javax.swing.JTextArea txt;
  // End of variables declaration//GEN-END:variables

  public boolean isClosed = false;
  private ArrayList<Integer> ids = new ArrayList<>();

  private void clear() {
    txt.setText("");
  }

  private void set(String log) {
    txt.setText(log);
  }

  private void loadLog() {
    try {
      int idx = logFile.getSelectedIndex();
      if (idx == -1) return;
      clear();
      String file = (String)logFile.getSelectedItem();
      int id = ids.get(idx);
      String log = new String(JF.readFile(file), "UTF-8");
      set(log);
      updateHistory(id);
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  private void loadHistory() {
    try {
      int idx = historyFile.getSelectedIndex();
      if (idx == -1) return;
      clear();
      String file = (String)historyFile.getSelectedItem();
      String log = new String(JF.readFile(file), "UTF-8");
      set(log);
    } catch (Exception e) {
      JFLog.log(e);
    }
  }

  private void updateHistory(int id) {
    try {
      historyFile.removeAllItems();
      File[] files = JFLog.getFiles(id);
      for(File file : files) {
        historyFile.addItem(file.getAbsolutePath());
      }
    } catch (Exception e) {
      JFLog.log(e);
    }
  }
}
