/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.impl.DefaultSftpClientFactory;

public class SFTP {
    private SshClient client;
    private ClientSession session;
    private SftpClient channel;
    private String path;
    private boolean aborted;
    private static final int bufsiz = 65536;

    public boolean connect(String host, int port, String username, String password, String key) {
        try {
            this.client = SshClient.setUpDefaultClient();
            this.client.start();
            ConnectFuture cf = this.client.connect(username, host, port);
            this.session = (ClientSession)((ConnectFuture)cf.verify(new CancelOption[0])).getSession();
            if (key == null || key.length() == 0) {
                this.session.addPasswordIdentity(password);
            } else {
                JFLog.log("using key:" + key);
                JFLog.log("TODO : set ssh key");
            }
            this.session.auth().verify(30000L, new CancelOption[0]);
            this.channel = DefaultSftpClientFactory.INSTANCE.createSftpClient(this.session);
        }
        catch (Exception e) {
            JFAWT.showMessage("Error", "Error:" + String.valueOf(e));
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public void disconnect() {
        try {
            this.channel.close();
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String remote_pwd() {
        String wd;
        try {
            wd = this.channel.canonicalPath(this.path);
            int i1 = wd.indexOf("\"");
            if (i1 != -1) {
                int i2 = wd.lastIndexOf("\"");
                if (i1 == i2) {
                    return "/";
                }
                wd = wd.substring(i1 + 1, i2);
            }
        }
        catch (Exception e) {
            return "/";
        }
        return wd;
    }

    public String[] remote_ls() {
        try {
            Iterable ls = this.channel.readDir(this.path);
            ArrayList<String> files = new ArrayList<String>();
            for (SftpClient.DirEntry e : ls) {
                files.add(e.getFilename());
            }
            return files.toArray(JF.StringArrayType);
        }
        catch (Exception e) {
            JFLog.log(e);
            return null;
        }
    }

    public void remote_chdir(String newpath) {
        try {
            this.path = newpath.startsWith("/") ? this.channel.canonicalPath(newpath) : this.channel.canonicalPath(this.path + "/" + newpath);
            this.remote_ls();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void copy(InputStream is, OutputStream os) throws Exception {
        byte[] buf = new byte[65536];
        while (is.available() > 0) {
            int read;
            int toread = is.available();
            if (toread > 65536) {
                toread = 65536;
            }
            if ((read = is.read(buf, 0, toread)) == -1) {
                throw new Exception("read error");
            }
            if (read <= 0) continue;
            os.write(buf, 0, read);
        }
    }

    public void download_file(File remote, File local) {
        try {
            FileOutputStream fos = new FileOutputStream(local);
            InputStream is = this.channel.read(this.path + "/" + remote.getName());
            this.copy(is, fos);
            is.close();
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void upload_file(File local, File remote) {
        try {
            FileInputStream fis = new FileInputStream(local);
            OutputStream os = this.channel.write(this.path + "/" + remote.getName());
            this.copy(fis, os);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void abort() {
        this.aborted = true;
    }

    public void remote_mkdir(String file) {
        try {
            this.channel.mkdir(file);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void remote_delete_file(String file) {
        try {
            this.channel.remove(file);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void remote_rename(String from, String to) {
        try {
            this.channel.rename(from, to);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void setPerms(int value, String remoteFile) {
        try {
            SftpClient.Attributes attr = new SftpClient.Attributes();
            attr.setPermissions(value);
            this.channel.setStat(remoteFile, attr);
            this.remote_chdir(".");
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void remote_delete_folder(String file) {
        try {
            this.channel.rmdir(file);
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }
}

