/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui;

import java.util.ArrayList;
import javaforce.webui.Component;
import javaforce.webui.WebUIClient;

public class Container
extends Component {
    private ArrayList<Component> components = new ArrayList();
    private int flexdir = 0;

    @Override
    public void setClient(WebUIClient client) {
        super.setClient(client);
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            this.get(a).setClient(client);
        }
    }

    @Override
    public void init() {
        super.init();
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            this.get(a).init();
        }
    }

    @Override
    public void events() {
        super.events();
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            this.get(a).events();
        }
    }

    public Component getComponent(String name) {
        if (this.name != null && this.name.equals(name)) {
            return this;
        }
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Container container;
            Component child = this.get(a);
            if (!(child instanceof Container ? (child = (container = (Container)child).getComponent(name)) != null : child.name != null && child.name.equals(name))) continue;
            return child;
        }
        return null;
    }

    public Component get(int idx) {
        return this.components.get(idx);
    }

    public Component get(String id) {
        if (id.equals(this.id)) {
            return this;
        }
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            Container container;
            Component comp = this.get(a);
            if (comp.id == null) continue;
            if (comp.id.equals(id)) {
                return comp;
            }
            if (!(comp instanceof Container) || (comp = (container = (Container)comp).get(id)) == null) continue;
            return comp;
        }
        return null;
    }

    public Component[] getAll() {
        return this.components.toArray(new Component[this.count()]);
    }

    public void set(int idx, Component c) {
        this.remove(idx);
        this.add(idx, c);
    }

    public void add(Component comp) {
        if (comp == null) {
            return;
        }
        this.add(this.count(), comp);
    }

    public void add(int idx, Component comp) {
        if (comp == null) {
            return;
        }
        comp.parent = this;
        Component before = idx < 0 || idx >= this.count() ? null : this.components.get(idx);
        this.components.add(idx, comp);
        if (this.client != null) {
            comp.setClient(this.client);
            comp.init();
        }
        if (this.id != null) {
            if (before == null) {
                this.sendEvent("add", new String[]{"html=" + comp.html()});
            } else {
                this.sendEvent("addbefore", new String[]{"html=" + comp.html(), "beforeid=" + before.id});
            }
            comp.events();
        }
    }

    public void remove(Component comp) {
        if (comp == null) {
            return;
        }
        this.components.remove(comp);
        if (this.id != null) {
            this.sendEvent("remove", new String[]{"child=" + comp.id});
        }
    }

    public void remove(int idx) {
        if (idx >= this.count()) {
            return;
        }
        Component comp = this.components.remove(idx);
        if (this.id != null) {
            this.sendEvent("remove", new String[]{"child=" + comp.id});
        }
    }

    public void removeAll() {
        while (this.count() > 0) {
            this.remove(0);
        }
    }

    public int count() {
        return this.components.size();
    }

    public void setFlexDirection(int dir) {
        switch (this.flexdir) {
            case 1: {
                this.removeClass("flexrow");
                break;
            }
            case 2: {
                this.removeClass("flexcol");
            }
        }
        this.flexdir = dir;
        switch (this.flexdir) {
            case 1: {
                this.addClass("flexrow");
                break;
            }
            case 2: {
                this.addClass("flexcol");
            }
        }
    }

    @Override
    public String html() {
        StringBuilder sb = new StringBuilder();
        sb.append("<div" + this.getAttrs() + ">");
        int cnt = this.count();
        for (int a = 0; a < cnt; ++a) {
            sb.append(this.get(a).html());
        }
        sb.append("</div>");
        return sb.toString();
    }
}

