/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.util.Arrays;

public abstract class JFArray<T> {
    protected T[] buf;
    protected int count = 0;
    public static int initSize = 64;

    public JFArray() {
        this.alloc(initSize);
    }

    public abstract void alloc(int var1);

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
    }

    public void append(T s) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = s;
        this.count = newcount;
    }

    public void append(T[] s) {
        int newcount = this.count + s.length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(s, 0, this.buf, this.count, s.length);
        this.count = newcount;
    }

    public void set(T[] s, int pos) {
        int newcount = pos + s.length;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(s, 0, this.buf, pos, s.length);
    }

    public T[] toArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public T[] toArray(int pos, int length) {
        return Arrays.copyOfRange(this.buf, pos, pos + length);
    }

    public T[] getBuffer() {
        return this.buf;
    }
}

