/*
 * Decompiled with CFR 0.152.
 */
package javaforce.awt;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.awt.JFAWT;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class ViewLog
extends JDialog {
    private File file;
    private Runnable refresh;
    private String msg;
    private JButton bRefresh;
    private JButton close;
    private JScrollPane jScrollPane1;
    private JTextArea txt;
    public boolean isClosed = false;

    public ViewLog(File file) {
        super((Frame)null, true);
        this.initComponents();
        this.init();
        this.file = file;
        this.load(file);
    }

    public ViewLog(String msg) {
        super((Frame)null, true);
        this.initComponents();
        this.init();
        this.msg = msg;
        this.load(msg);
    }

    public ViewLog(String msg, Runnable refresh) {
        super((Frame)null, true);
        this.initComponents();
        this.init();
        this.msg = msg;
        this.refresh = refresh;
        this.load(msg);
    }

    private void init() {
        JFAWT.centerWindow(this);
    }

    private void initComponents() {
        this.close = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.txt = new JTextArea();
        this.bRefresh = new JButton();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ViewLog.this.formWindowClosing(evt);
            }
        });
        this.close.setText("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLog.this.closeActionPerformed(evt);
            }
        });
        this.txt.setEditable(false);
        this.txt.setColumns(20);
        this.txt.setRows(5);
        this.txt.setText("[loading...]");
        this.jScrollPane1.setViewportView(this.txt);
        this.bRefresh.setText("Refresh");
        this.bRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewLog.this.bRefreshActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.bRefresh).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.close)).addComponent(this.jScrollPane1, -1, 498, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 417, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.close).addComponent(this.bRefresh)).addContainerGap()));
        this.pack();
    }

    private void closeActionPerformed(ActionEvent evt) {
        this.isClosed = true;
        this.dispose();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.isClosed = true;
    }

    private void bRefreshActionPerformed(ActionEvent evt) {
        this.doRefresh();
    }

    public static void main(String[] args) {
        final String file = args[0];
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ViewLog(new File(file)).setVisible(true);
            }
        });
    }

    private void load(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] txt = JF.readAll(fis);
            this.load(new String(txt));
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private void load(String msg) {
        this.txt.setText(msg);
    }

    public void setText(String msg) {
        this.msg = msg;
        this.load(msg);
    }

    public void setRefresh(Runnable refresh) {
        this.refresh = refresh;
    }

    private void doRefresh() {
        if (this.file != null) {
            this.load(this.file);
        }
        if (this.refresh != null) {
            this.refresh.run();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

