/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import javaforce.awt.JFImage;

public class VideoBuffer {
    private JFImage[] images;
    private int head = 0;
    private int tail = 0;
    private boolean headInUse;
    private boolean tailInUse;
    private int width;
    private int height;

    public VideoBuffer(int width, int height, int frames) {
        this.images = new JFImage[frames];
        for (int a = 0; a < frames; ++a) {
            this.images[a] = new JFImage(width, height);
        }
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public JFImage getNewFrame() {
        int newHead;
        if (this.headInUse) {
            this.freeNewFrame();
        }
        if ((newHead = this.head + 1) == this.images.length) {
            newHead = 0;
        }
        if (newHead == this.tail) {
            return null;
        }
        this.headInUse = true;
        return this.images[this.head];
    }

    public void freeNewFrame() {
        if (!this.headInUse) {
            return;
        }
        this.headInUse = false;
        ++this.head;
        if (this.head == this.images.length) {
            this.head = 0;
        }
    }

    public JFImage getNextFrame() {
        if (this.tailInUse) {
            this.freeNextFrame();
        }
        if (this.tail == this.head) {
            return null;
        }
        this.tailInUse = true;
        return this.images[this.tail];
    }

    public void freeNextFrame() {
        if (!this.tailInUse) {
            return;
        }
        this.tailInUse = false;
        ++this.tail;
        if (this.tail == this.images.length) {
            this.tail = 0;
        }
    }

    public int size() {
        int t = this.tail;
        int h = this.head;
        if (t == h) {
            return 0;
        }
        if (h > t) {
            return h - t;
        }
        return this.images.length - t + h;
    }

    public void clear() {
        this.tail = this.head;
    }

    public static native float compareFrames(int[] var0, int[] var1, int var2, int var3);
}

