/*
 * Decompiled with CFR 0.152.
 */
package javaforce.pi;

import java.io.File;
import java.io.FileInputStream;
import javaforce.JFLog;

public class GPIO {
    public static boolean init() {
        try {
            File file = new File("/proc/iomem");
            if (!file.exists()) {
                throw new Exception("/proc/iomem not found");
            }
            FileInputStream fis = new FileInputStream(file);
            byte[] data = fis.readAllBytes();
            fis.close();
            String[] lns = new String(data).split("\n");
            int addr = -1;
            for (int a = 0; a < lns.length; ++a) {
                String ln = lns[a];
                if (!ln.contains("gpio")) continue;
                addr = Integer.valueOf(ln.substring(0, 8), 16);
                break;
            }
            if (addr == -1) {
                throw new Exception("GPIO not found in /proc/iomem");
            }
            return GPIO.ninit(addr);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private static native boolean ninit(int var0);

    public static native boolean configOutput(int var0);

    public static native boolean configInput(int var0);

    public static native boolean write(int var0, boolean var1);

    public static native boolean read(int var0);
}

