/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import javaforce.JFLog;
import javaforce.utils.ImageConvert;

public class GenIcons {
    public static void main(String[] args) {
        try {
            File[] files;
            for (File svg2 : files = new File("src/javaforce/icons/svg").listFiles()) {
                GenIcons.gen(svg2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static void gen(File svg2) {
        String name = svg2.getName();
        int idx = name.indexOf(46);
        String base = name.substring(0, idx);
        String i16 = "src/javaforce/icons/16/" + base + ".png";
        File f16 = new File(i16);
        String i32 = "src/javaforce/icons/32/" + base + ".png";
        File f32 = new File(i32);
        long svg_date = svg2.lastModified();
        long i16_date = f16.lastModified();
        long i32_date = f32.lastModified();
        if (svg_date < i16_date || svg_date < i32_date) {
            return;
        }
        String temp = "GenIcons-64.png";
        ImageConvert.main(new String[]{svg2.getPath(), temp, "size=64,64", "fill=00ffffff"});
        ImageConvert.main(new String[]{temp, i32, "scale=50,50"});
        ImageConvert.main(new String[]{temp, i16, "scale=25,25"});
        new File(temp).delete();
    }
}

