/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip.codec;

import javaforce.BE;
import javaforce.JFLog;
import javaforce.codec.opus.OpusDecoder;
import javaforce.codec.opus.OpusEncoder;
import javaforce.voip.RTP;
import javaforce.voip.RTPAudioCoder;
import javaforce.voip.RTPChannel;

public class opus
implements RTPAudioCoder {
    private OpusEncoder encoder;
    private OpusDecoder decoder;
    private RTP rtp;
    private int rtp_id;
    private int rate;
    private int nsamples;
    private byte[] encoded;
    private int decode_timestamp;

    public opus(RTP rtp, int rate) {
        this.rtp = rtp;
        this.rate = rate;
        this.nsamples = 960;
    }

    @Override
    public void setid(int id) {
        this.rtp_id = id;
    }

    @Override
    public byte[] encode(short[] samples) {
        if (this.encoder == null) {
            this.encoder = new OpusEncoder();
            this.encoder.open();
        }
        byte[] packet = this.encoder.encode(samples);
        int encoded_length = packet.length;
        if (this.encoded == null || this.encoded.length != encoded_length + 12) {
            this.encoded = new byte[encoded_length + 12];
        }
        System.arraycopy(packet, 0, this.encoded, 12, encoded_length);
        RTPChannel rtpChannel = this.rtp.getDefaultChannel();
        RTPChannel.buildHeader(this.encoded, this.rtp_id, rtpChannel.getseqnum(), rtpChannel.gettimestamp(this.nsamples), rtpChannel.getssrc(), false);
        return this.encoded;
    }

    @Override
    public short[] decode(byte[] encoded, int off, int length) {
        if (this.decoder == null) {
            this.decoder = new OpusDecoder();
            this.decoder.open();
        }
        int decode_timestamp = BE.getuint32(encoded, off + 4);
        if (this.decode_timestamp == 0) {
            this.decode_timestamp = decode_timestamp;
        } else {
            if (RTP.debug) {
                JFLog.log("opus:timestamp = " + decode_timestamp + ":" + (this.decode_timestamp + this.nsamples == decode_timestamp ? "ok" : "lost packet"));
            }
            this.decode_timestamp = decode_timestamp;
        }
        return this.decoder.decode(encoded, off + 12, length - 12);
    }

    @Override
    public int getSampleRate() {
        return this.rate;
    }

    @Override
    public int getPacketSize() {
        return -1;
    }

    @Override
    public void close() {
        if (this.encoder != null) {
            this.encoder.close();
            this.encoder = null;
        }
        if (this.decoder != null) {
            this.decoder.close();
            this.decoder = null;
        }
    }
}

