/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import java.util.ArrayList;
import javaforce.access.AccessControl;
import javaforce.access.Group;
import javaforce.access.Groups;
import javaforce.access.User;
import javaforce.webui.Button;
import javaforce.webui.Component;
import javaforce.webui.FlexBox;
import javaforce.webui.GridLayout;
import javaforce.webui.Label;
import javaforce.webui.ListBox;
import javaforce.webui.Panel;
import javaforce.webui.PopupPanel;
import javaforce.webui.TabPanel;
import javaforce.webui.TextField;
import javaforce.webui.ToolBar;
import javaforce.webui.WebUIClient;
import javaforce.webui.panel.ResetPasswordPanel;
import javaforce.webui.panel.SelectFromListPanel;

public class EditUserPanel
extends PopupPanel {
    private TextField name;
    private TextField full;
    private TextField desc;
    private ListBox list;
    private ArrayList<String> removes;
    private User user;
    private AccessControl access;

    public EditUserPanel(String title, WebUIClient client) {
        super(title);
        this.setModal(true);
        this.access = client.getAccessControl();
        TabPanel tabs = new TabPanel();
        this.add(tabs);
        Panel account = new Panel();
        GridLayout grid = new GridLayout(2, 0, new int[]{3, 1});
        account.add(grid);
        Component[] componentArray = new Component[2];
        componentArray[0] = new Label("Username");
        this.name = new TextField("");
        componentArray[1] = this.name;
        grid.addRow(componentArray);
        Component[] componentArray2 = new Component[2];
        componentArray2[0] = new Label("Full Name");
        this.full = new TextField("");
        componentArray2[1] = this.full;
        grid.addRow(componentArray2);
        Component[] componentArray3 = new Component[2];
        componentArray3[0] = new Label("Description");
        this.desc = new TextField("");
        componentArray3[1] = this.desc;
        grid.addRow(componentArray3);
        this.name.setReadonly(true);
        ToolBar tools = new ToolBar();
        account.add(tools);
        Button reset_password = new Button("Reset Password");
        tools.add(reset_password);
        tabs.addTab(account, "Account");
        Panel membership = new Panel();
        this.list = new ListBox();
        this.list.setWidth(256);
        this.list.setHeight(256);
        membership.add(this.list);
        tools = new ToolBar();
        membership.add(tools);
        Button add = new Button("Add");
        tools.add(add);
        Button remove = new Button("Remove");
        tools.add(remove);
        tabs.addTab(membership, "Membership");
        tools = new ToolBar();
        this.add(tools);
        tools.add(new FlexBox());
        Button accept = new Button("Accept");
        tools.add(accept);
        Button cancel = new Button("Cancel");
        tools.add(cancel);
        reset_password.addClickListener((event, cmp) -> {
            ResetPasswordPanel reset = client.getResetPasswordPanel();
            reset.set(this.user);
            reset.setVisible(true);
        });
        add.addClickListener((event, cmp) -> {
            SelectFromListPanel select = client.getSelectFromListPanel();
            select.set(this.access.getGroups(), "Add Group", () -> {
                String group = select.getSelectedText();
                if (this.list.contains(group)) {
                    return;
                }
                this.list.add(group);
                if (this.removes.contains(group)) {
                    this.removes.remove(group);
                }
            });
            select.setVisible(true);
        });
        remove.addClickListener((event, cmp) -> {
            int idx = this.list.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            String user = this.list.getSelectedItem();
            this.list.remove(idx);
            this.removes.add(user);
        });
        accept.addClickListener((event, cmp) -> {
            Object object = this.access.lock;
            synchronized (object) {
                Group group;
                this.user.full = this.full.getText();
                this.user.desc = this.desc.getText();
                int cnt = this.list.getCount();
                Groups groups = this.access.getGroupsList();
                for (int i = 0; i < cnt; ++i) {
                    String groupName = this.list.getItem(i);
                    group = groups.getGroup(groupName);
                    if (group.contains(this.user.name)) continue;
                    group.addUser(this.user.name);
                }
                for (String groupName : this.removes) {
                    group = groups.getGroup(groupName);
                    if (!group.contains(this.user.name)) continue;
                    group.removeUser(this.user.name);
                }
                this.access.saveUsers();
            }
            this.setVisible(false);
        });
        cancel.addClickListener((event, cmp) -> this.setVisible(false));
    }

    public void set(User user) {
        Group[] gps;
        this.user = user;
        this.name.setText(user.name);
        this.full.setText(user.full);
        this.desc.setText(user.desc);
        this.list.removeAll();
        for (Group group : gps = this.access.getGroups()) {
            if (!group.contains(user.name)) continue;
            this.list.add(group.name);
        }
        this.removes = new ArrayList();
    }
}

