/*
 * Decompiled with CFR 0.152.
 */
package javaforce.webui.panel;

import javaforce.JF;
import javaforce.access.AccessControl;
import javaforce.access.User;
import javaforce.webui.Button;
import javaforce.webui.Color;
import javaforce.webui.Component;
import javaforce.webui.GridLayout;
import javaforce.webui.Label;
import javaforce.webui.PopupPanel;
import javaforce.webui.Row;
import javaforce.webui.TextField;
import javaforce.webui.WebUIClient;

public class NewUserPanel
extends PopupPanel {
    private TextField name;
    private TextField full;
    private TextField desc;
    private TextField pass1;
    private TextField pass2;
    private AccessControl access;

    public NewUserPanel(String title, WebUIClient client) {
        super(title);
        this.setModal(true);
        GridLayout grid = new GridLayout(2, 0, new int[]{3, 1});
        this.add(grid);
        Component[] componentArray = new Component[2];
        componentArray[0] = new Label("Username");
        this.name = new TextField("");
        componentArray[1] = this.name;
        grid.addRow(componentArray);
        Component[] componentArray2 = new Component[2];
        componentArray2[0] = new Label("Full Name");
        this.full = new TextField("");
        componentArray2[1] = this.full;
        grid.addRow(componentArray2);
        Component[] componentArray3 = new Component[2];
        componentArray3[0] = new Label("Description");
        this.desc = new TextField("");
        componentArray3[1] = this.desc;
        grid.addRow(componentArray3);
        Component[] componentArray4 = new Component[2];
        componentArray4[0] = new Label("Password");
        this.pass1 = new TextField("");
        componentArray4[1] = this.pass1;
        grid.addRow(componentArray4);
        Component[] componentArray5 = new Component[2];
        componentArray5[0] = new Label("Confirm Password");
        this.pass2 = new TextField("");
        componentArray5[1] = this.pass2;
        grid.addRow(componentArray5);
        this.pass1.setPassword(true);
        this.pass2.setPassword(true);
        Row row = new Row();
        this.add(row);
        Label msg = new Label("");
        msg.setColor(Color.red);
        row.add(msg);
        row = new Row();
        this.add(row);
        Button accept = new Button("Create");
        row.add(accept);
        Button cancel = new Button("Cancel");
        row.add(cancel);
        accept.addClickListener((event, cmp) -> {
            String new_name = JF.filter(this.name.getText(), JF.filter_id);
            if (new_name.length() == 0) {
                msg.setText("Username too short");
                return;
            }
            String new_full = this.full.getText();
            String new_desc = this.desc.getText();
            String p1 = this.pass1.getText();
            String p2 = this.pass2.getText();
            if (p1.length() < 4) {
                msg.setText("Password too short");
                return;
            }
            if (!p1.equals(p2)) {
                msg.setText("Passwords do not match");
                return;
            }
            User user = new User(new_name, p1, new_desc);
            user.full = new_full;
            client.getAccessControl().addUser(user);
            this.setVisible(false);
        });
        cancel.addClickListener((event, cmp) -> this.setVisible(false));
    }

    public void clear() {
        this.name.setText("");
        this.full.setText("");
        this.desc.setText("");
        this.pass1.setText("");
        this.pass2.setText("");
    }
}

