/*
 * Decompiled with CFR 0.152.
 */
package io.secidea.security;

import io.secidea.security.J8ApiBridge;
import io.secidea.security.ReflectionRestrictions;
import java.lang.reflect.Modifier;
import java.util.Set;

public final class Reflection {
    private static final Set<ReflectionRestrictions> defaultRestrictions = J8ApiBridge.setOf(ReflectionRestrictions.MUST_NOT_INVOLVE_CODE_EXECUTION);
    private static final Set<Class<?>> codeLoadingTypes = J8ApiBridge.setOf(Runtime.class, ProcessBuilder.class, Class.class, ClassLoader.class);
    private static final Set<String> codeLoadingPackages = J8ApiBridge.setOf("java.lang.invoke.", "org.apache.commons.collections.functors.", "bsh.", "mozilla.javascript.", "groovy.", "org.python.");
    private static final String typeNotAllowedMessage = "type not allowed";

    private Reflection() {
    }

    public static Set<ReflectionRestrictions> defaultRestrictions() {
        return defaultRestrictions;
    }

    public static Class<?> loadAndVerifyPackage(String name, String expectedPackage) throws ClassNotFoundException {
        if (expectedPackage == null) {
            throw new IllegalArgumentException("expectedPackage");
        }
        Class<?> type = Reflection.loadAndVerify(name, Reflection.defaultRestrictions());
        String loadedTypeName = type.getName();
        if (!loadedTypeName.startsWith(expectedPackage)) {
            throw new SecurityException("unexpected package on type: " + loadedTypeName);
        }
        return type;
    }

    public static Class<?> loadAndVerify(String name) throws ClassNotFoundException {
        return Reflection.loadAndVerify(name, Reflection.defaultRestrictions());
    }

    public static Class<?> loadAndVerify(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        return Reflection.loadAndVerify(name, Reflection.defaultRestrictions(), () -> Class.forName(name, initialize, loader));
    }

    public static Class<?> loadAndVerify(String name, Set<ReflectionRestrictions> restrictions) throws ClassNotFoundException {
        return Reflection.loadAndVerify(name, restrictions, () -> Class.forName(name));
    }

    private static Class<?> loadAndVerify(String name, Set<ReflectionRestrictions> restrictions, ClassSupplier classSupplier) throws ClassNotFoundException {
        int modifiers;
        if (restrictions.contains((Object)ReflectionRestrictions.MUST_NOT_INVOLVE_CODE_EXECUTION)) {
            for (String codeLoadingPackage : codeLoadingPackages) {
                if (!name.startsWith(codeLoadingPackage)) continue;
                throw new SecurityException(typeNotAllowedMessage);
            }
        }
        Class<?> type = classSupplier.get();
        if (restrictions.contains((Object)ReflectionRestrictions.MUST_BE_PUBLIC) && !Modifier.isPublic(modifiers = type.getModifiers())) {
            throw new SecurityException("type must be public");
        }
        if (restrictions.contains((Object)ReflectionRestrictions.MUST_NOT_INVOLVE_CODE_EXECUTION) && codeLoadingTypes.contains(type)) {
            throw new SecurityException(typeNotAllowedMessage);
        }
        return type;
    }

    private static interface ClassSupplier {
        public Class<?> get() throws ClassNotFoundException;
    }
}

