/*
 * Decompiled with CFR 0.152.
 */
package io.secidea.security;

import io.secidea.security.J8ApiBridge;
import io.secidea.security.PatternBasedHostValidator;
import java.util.Set;
import java.util.regex.Pattern;

public interface HostValidator {
    public static final HostValidator ALLOW_ALL = host -> true;
    public static final HostValidator DENY_COMMON_INFRASTRUCTURE_TARGETS = new HostValidator(){
        private final Set<String> knownInfrastructureTargets = J8ApiBridge.setOf("192.168.1.1", "3232235777", "169.254.169.254", "2852039166");

        @Override
        public boolean isAllowed(String host) {
            String cleanedHost = host.trim();
            return !this.knownInfrastructureTargets.contains(cleanedHost);
        }
    };

    public boolean isAllowed(String var1);

    public static HostValidator fromAllowedHostPattern(Pattern allowPattern) {
        return new PatternBasedHostValidator(allowPattern);
    }

    public static HostValidator fromAllowedHostDomain(String domainName) {
        Pattern p = Pattern.compile("(.*\\." + Pattern.quote(domainName) + "|" + Pattern.quote(domainName) + ")");
        return new PatternBasedHostValidator(p);
    }
}

