/*
 * Decompiled with CFR 0.152.
 */
package io.secidea.security;

import io.secidea.security.J8ApiBridge;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.input.buffer.CircularByteBuffer;

public final class XMLDecoderSecurity {
    private XMLDecoderSecurity() {
    }

    public static InputStream hardenStream(InputStream is) {
        return XMLDecoderSecurity.tokenDetectingInputStream(is, J8ApiBridge.listOf("java.lang.Runtime", "java.lang.ProcessBuilder", "java.io.FileOutputStream"));
    }

    private static InputStream tokenDetectingInputStream(InputStream is, List<String> wordsToWatch) {
        List byteStreamsToWatch = wordsToWatch.stream().map(word -> word.getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList());
        return new TokenDetectingInputStream(is, byteStreamsToWatch);
    }

    private static class TokenDetectingInputStream
    extends InputStream {
        private final InputStream is;
        private final List<byte[]> tokensToWatch;
        private final CircularByteBuffer circularByteBuffer;

        private TokenDetectingInputStream(InputStream is, List<byte[]> tokensToWatch) {
            this.is = Objects.requireNonNull(is);
            if (tokensToWatch.size() == 0) {
                throw new IllegalArgumentException("need some tokens to watch");
            }
            this.tokensToWatch = tokensToWatch;
            int maxLength = 0;
            for (byte[] token : tokensToWatch) {
                if (token == null || token.length == 0) {
                    throw new IllegalArgumentException("can't have null / zero sized token");
                }
                if (token.length <= maxLength) continue;
                maxLength = token.length;
            }
            this.circularByteBuffer = new CircularByteBuffer(maxLength);
        }

        @Override
        public int read() throws IOException {
            int read = this.is.read();
            this.circularByteBuffer.add((byte)read);
            for (byte[] token : this.tokensToWatch) {
                if (!this.circularByteBuffer.peek(token, 0, token.length)) continue;
                throw new SecurityException("encountered token");
            }
            if (!this.circularByteBuffer.hasSpace()) {
                this.circularByteBuffer.read();
            }
            return read;
        }
    }
}

