/*
 * Decompiled with CFR 0.152.
 */
package io.secidea.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipSecurity {
    private ZipSecurity() {
    }

    public static ZipInputStream createHardenedInputStream(InputStream stream, Charset charset) {
        return new HardenedZipInputStream(stream, charset);
    }

    public static ZipInputStream createHardenedInputStream(InputStream stream) {
        return new HardenedZipInputStream(stream);
    }

    private static class HardenedZipInputStream
    extends ZipInputStream {
        private HardenedZipInputStream(InputStream in) {
            super(in);
        }

        private HardenedZipInputStream(InputStream in, Charset charset) {
            super(in, charset);
        }

        @Override
        public ZipEntry getNextEntry() throws IOException {
            ZipEntry entry = super.getNextEntry();
            if (entry == null) {
                return null;
            }
            String name = entry.getName();
            if (!name.trim().isEmpty()) {
                if (this.isRootFileEntry(name)) {
                    throw new SecurityException("encountered zip file path that is absolute: " + name);
                }
                if (this.containsEscapesAndTargetsBelowRoot(name)) {
                    throw new SecurityException("path to sensitive locations contained escapes: " + name);
                }
            }
            return entry;
        }

        private boolean containsEscapesAndTargetsBelowRoot(String name) {
            if (name.contains("../") || name.contains("..\\")) {
                try {
                    if (this.isBelowOrSisterToCurrentDirectory(name)) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        private boolean isBelowOrSisterToCurrentDirectory(String untrustedFileWithEscapes) throws IOException {
            File currentDirectory = new File("").getCanonicalFile();
            Path currentPathRoot = currentDirectory.toPath();
            File untrustedFile = new File(currentDirectory, untrustedFileWithEscapes);
            Path pathWithEscapes = untrustedFile.getCanonicalFile().toPath();
            return !pathWithEscapes.startsWith(currentPathRoot);
        }

        private boolean isRootFileEntry(String name) {
            return name.startsWith("/");
        }
    }
}

