/*
 * Decompiled with CFR 0.152.
 */
package io.github.testra.java.client.api;

import io.github.testra.java.client.model.Execution;
import io.github.testra.java.client.model.ExecutionRequest;
import io.github.testra.java.client.model.TestExecutionStats;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ExecutionApi {
    @Headers(value={"Content-Type:application/json"})
    @POST(value="projects/{projectId}/executions")
    public Call<Execution> createExecution(@Path(value="projectId") String var1, @Body ExecutionRequest var2);

    @Headers(value={"Content-Type:application/json"})
    @DELETE(value="projects/{projectId}/executions/{id}")
    public Call<Execution> deleteExecution(@Path(value="projectId") String var1, @Path(value="id") String var2);

    @Headers(value={"Content-Type:application/json"})
    @GET(value="projects/{projectId}/executions/{id}")
    public Call<Execution> getExecution(@Path(value="projectId") String var1, @Path(value="id") String var2);

    @Headers(value={"Content-Type:application/json"})
    @GET(value="projects/{projectId}/executions/{id}/result-stats")
    public Call<TestExecutionStats> getExecutionResultStats(@Path(value="projectId") String var1, @Path(value="id") String var2);

    @Headers(value={"Content-Type:application/json"})
    @GET(value="projects/{projectId}/executions")
    public Call<List<Execution>> getExecutions(@Path(value="projectId") String var1);

    @Headers(value={"Content-Type:application/json"})
    @GET(value="executions/recents")
    public Call<List<Execution>> recentExecutions(@Query(value="size") Integer var1);

    @Headers(value={"Content-Type:application/json"})
    @PUT(value="projects/{projectId}/executions/{id}")
    public Call<Execution> updateExecution(@Path(value="projectId") String var1, @Path(value="id") String var2, @Body ExecutionRequest var3);
}

