/*
 * Decompiled with CFR 0.152.
 */
package io.github.testra.java.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class ProjectRequest {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="projectType")
    private ProjectTypeEnum projectType = null;
    @SerializedName(value="description")
    private String description = null;

    public ProjectRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProjectRequest projectType(ProjectTypeEnum projectType) {
        this.projectType = projectType;
        return this;
    }

    @ApiModelProperty(value="")
    public ProjectTypeEnum getProjectType() {
        return this.projectType;
    }

    public void setProjectType(ProjectTypeEnum projectType) {
        this.projectType = projectType;
    }

    public ProjectRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectRequest projectRequest = (ProjectRequest)o;
        return Objects.equals(this.name, projectRequest.name) && Objects.equals((Object)this.projectType, (Object)projectRequest.projectType) && Objects.equals(this.description, projectRequest.description);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.projectType, this.description});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProjectRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectType: ").append(this.toIndentedString((Object)this.projectType)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ProjectTypeEnum {
        TEST("TEST"),
        SIMULATION("SIMULATION"),
        SECURITY("SECURITY");

        private String value;

        private ProjectTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ProjectTypeEnum fromValue(String text) {
            for (ProjectTypeEnum b : ProjectTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ProjectTypeEnum> {
            public void write(JsonWriter jsonWriter, ProjectTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ProjectTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ProjectTypeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

