/*
 * Decompiled with CFR 0.152.
 */
package io.github.testra.java.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum Result {
    PASSED("PASSED"),
    FAILED("FAILED"),
    PENDING("PENDING"),
    SKIPPED("SKIPPED"),
    AMBIGUOUS("AMBIGUOUS"),
    UNDEFINED("UNDEFINED"),
    UNKNOWN("UNKNOWN");

    private String value;

    private Result(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Result fromValue(String text) {
        for (Result b : Result.values()) {
            if (!String.valueOf(b.value).equals(text)) continue;
            return b;
        }
        return null;
    }

    public static class Adapter
    extends TypeAdapter<Result> {
        public void write(JsonWriter jsonWriter, Result enumeration) throws IOException {
            jsonWriter.value(enumeration.getValue());
        }

        public Result read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return Result.fromValue(String.valueOf(value));
        }
    }
}

