/*
 * Decompiled with CFR 0.152.
 */
package io.github.tomdw.java.modules.context.boot.internal;

import io.github.tomdw.java.modules.context.boot.api.ModuleServiceReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Qualifier;

public class ModuleServiceReferenceElement {
    private static final System.Logger LOGGER = System.getLogger(ModuleServiceReferenceElement.class.getName());
    private final Class<?> declaredType;
    private final Class<?> moduleServiceType;

    public static ModuleServiceReferenceElement of(Field field) {
        return new ModuleServiceReferenceElement(field, field.getType(), field.getGenericType());
    }

    public static ModuleServiceReferenceElement of(Parameter parameter) {
        return new ModuleServiceReferenceElement(parameter, parameter.getType(), parameter.getParameterizedType());
    }

    private ModuleServiceReferenceElement(AnnotatedElement annotatedElement, Class<?> declaredType, Type genericTypeForServicesList) {
        this.validateModuleServiceReferenceAnnotationIsPresent(annotatedElement);
        this.declaredType = declaredType;
        this.moduleServiceType = this.determineModuleServiceType(declaredType, genericTypeForServicesList);
        if (this.isServicesList()) {
            this.validateListIsReferencedUsingAName(annotatedElement);
        }
    }

    private void validateModuleServiceReferenceAnnotationIsPresent(AnnotatedElement annotatedElement) {
        if (!annotatedElement.isAnnotationPresent(ModuleServiceReference.class)) {
            throw new IllegalArgumentException(ModuleServiceReferenceElement.class.getSimpleName() + " needs to be annotated with annotation " + ModuleServiceReference.class.getSimpleName());
        }
    }

    private void validateListIsReferencedUsingAName(AnnotatedElement annotatedElement) {
        if (!this.isReferencedUsingName(annotatedElement)) {
            LOGGER.log(System.Logger.Level.ERROR, "Injecting a list of " + this.moduleServiceType.getName() + " requires a Qualifier or Named annotation with value " + this.getBeanNameToUseForServiceFactory());
            throw new IllegalStateException("Injecting a list of " + this.moduleServiceType.getName() + " requires a Qualifier or Named annotation with value " + this.getBeanNameToUseForServiceFactory());
        }
    }

    String getBeanNameToUseForServiceFactory() {
        Object name = this.decapitalizeFirstLetter(this.moduleServiceType.getSimpleName());
        if (this.isServicesList()) {
            name = (String)name + "List";
        }
        return name;
    }

    private String decapitalizeFirstLetter(String input) {
        return Character.toLowerCase(input.charAt(0)) + input.substring(1);
    }

    boolean isServicesList() {
        return this.declaredType.isAssignableFrom(List.class);
    }

    Class<?> getModuleServiceType() {
        return this.moduleServiceType;
    }

    private Class<?> determineModuleServiceType(Class<?> declaredType, Type genericTypeForServicesList) {
        if (this.isServicesList()) {
            ParameterizedType listGenericType = (ParameterizedType)genericTypeForServicesList;
            if (this.checkIfContentOfGenericListHasGenerics(listGenericType)) {
                return (Class)((ParameterizedType)listGenericType.getActualTypeArguments()[0]).getRawType();
            }
            return (Class)listGenericType.getActualTypeArguments()[0];
        }
        return declaredType;
    }

    private boolean checkIfContentOfGenericListHasGenerics(ParameterizedType listGenericType) {
        return listGenericType.getActualTypeArguments()[0] instanceof ParameterizedType;
    }

    private boolean isReferencedUsingName(AnnotatedElement annotatedElement) {
        String referenceName = this.getBeanNameToUseForServiceFactory();
        if (annotatedElement.isAnnotationPresent(Named.class)) {
            return annotatedElement.getAnnotation(Named.class).value().equals(referenceName);
        }
        if (annotatedElement.isAnnotationPresent(Qualifier.class)) {
            return annotatedElement.getAnnotation(Qualifier.class).value().equals(referenceName);
        }
        return false;
    }
}

