/*
 * Decompiled with CFR 0.152.
 */
package A501JavaSDKPackage.WebClients;

import A501JavaSDKPackage.Models.A501ClientModel.A501ClientRequestModel;
import A501JavaSDKPackage.Models.Encryption.EncryptedResponseModel;
import A501JavaSDKPackage.Models.Proxy.ProxySetting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class BaseAPIWebClient {
    protected static boolean IsNullOrEmpty(String val) {
        return val == null || val.isEmpty();
    }

    protected static Key generateSessionKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        SecretKey sessionKey = null;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = new SecureRandom();
            int keyBitSize = 128;
            keyGenerator.init(keyBitSize, secureRandom);
            sessionKey = keyGenerator.generateKey();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sessionKey;
    }

    protected static String encryptUsingPublicKey(Key sessionKey, byte[] PublicKey2) throws IOException, GeneralSecurityException {
        String encryptedKey = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(PublicKey2);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            PublicKey publicKey1 = cert.getPublicKey();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey1.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher c = Cipher.getInstance("RSA");
            c.init(1, publicKey);
            byte[] encodeKey = sessionKey.getEncoded();
            byte[] base64 = Base64.getEncoder().encode(encodeKey);
            byte[] s = c.doFinal(base64);
            encryptedKey = Base64.getEncoder().encodeToString(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedKey;
    }

    protected String ReadFile(String jsonPath) throws IOException {
        try {
            File xmlFile = new File(jsonPath);
            FileReader fileReader = new FileReader(xmlFile);
            BufferedReader bufReader = new BufferedReader(fileReader);
            StringBuilder sb = new StringBuilder();
            String line = bufReader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = bufReader.readLine();
            }
            String xmlString = sb.toString();
            System.out.println(xmlString);
            bufReader.close();
            return xmlString;
        }
        catch (IOException e) {
            System.out.println("Error while retrieving data\u2026");
            throw e;
        }
    }

    protected static String encryptUsingSessionKey(Key sessionKey, String plainText) {
        String encryptedData = null;
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, sessionKey);
            byte[] cipherText = cipher.doFinal(plainText.getBytes());
            encryptedData = Base64.getEncoder().encodeToString(cipherText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encryptedData;
    }

    protected static PrivateKey getPrivateKey(byte[] privateKey, String privateKeyPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, CertificateException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(privateKey);
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(inputStream, privateKeyPassword.toCharArray());
        String alias = keyStore.aliases().nextElement().toString();
        PrivateKey privateKeyN = (PrivateKey)keyStore.getKey(alias, privateKeyPassword.toCharArray());
        return privateKeyN;
    }

    protected static String signData(PrivateKey _privateKey, String signingParams) {
        String signedJson = "";
        try {
            Signature sig = Signature.getInstance("SHA512WithRSA");
            sig.initSign(_privateKey);
            sig.update(signingParams.getBytes("UTF-16LE"));
            signedJson = Base64.getEncoder().encodeToString(sig.sign());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return signedJson;
    }

    protected static boolean verifyJson(EncryptedResponseModel encryptedRespomsemodel, PublicKey publicKey) {
        try {
            String resposneJson = encryptedRespomsemodel.encryptedData + encryptedRespomsemodel.encryptionKey;
            byte[] data = resposneJson.getBytes("UTF-16LE");
            byte[] signature = Base64.getDecoder().decode(encryptedRespomsemodel.signature);
            Signature sig = Signature.getInstance("SHA512withRSA");
            sig.initVerify(publicKey);
            sig.update(data);
            return sig.verify(signature);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected static void verifySignature(EncryptedResponseModel encryptedRespomsemodel, byte[] publicKeyBytes) throws Exception {
        PublicKey publicKey = BaseAPIWebClient.GetPublicKey(publicKeyBytes);
        if (!BaseAPIWebClient.verifyJson(encryptedRespomsemodel, publicKey)) {
            throw new Exception("Signature Not Verified");
        }
    }

    protected static PublicKey GetPublicKey(byte[] publicKeyBytes) {
        PublicKey publicKey = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(publicKeyBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            PublicKey publicKey1 = cert.getPublicKey();
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey1.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return publicKey;
    }

    protected static Key decryptDataAsymmetrically(String sessionKey, String privatePassword, byte[] privateKeyBytes) {
        SecretKeySpec SessionKey = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(privateKeyBytes);
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(inputStream, privatePassword.toCharArray());
            String alias = keyStore.aliases().nextElement().toString();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, privatePassword.toCharArray());
            Cipher c = Cipher.getInstance("RSA");
            c.init(2, privateKey);
            byte[] encodeKey = Base64.getDecoder().decode(sessionKey.getBytes());
            byte[] s = c.doFinal(encodeKey);
            byte[] decodedSessionKey = Base64.getDecoder().decode(s);
            SessionKey = new SecretKeySpec(decodedSessionKey, "AES");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SessionKey;
    }

    protected static String decryptDataSymmetrically(Key sessionKey, String encryptedData) {
        String decryptedText = "";
        try {
            byte[] decodeData = Base64.getDecoder().decode(encryptedData);
            Cipher Decipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            Decipher.init(2, sessionKey);
            byte[] cipherText = Decipher.doFinal(decodeData);
            decryptedText = new String(cipherText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return decryptedText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String WebClientPost(String data, A501ClientRequestModel a501ClientRequestModel) throws NoSuchAlgorithmException {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        String responseContent = "";
        try {
            HttpPost httpPost = new HttpPost(a501ClientRequestModel.getApiURL());
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Domain", a501ClientRequestModel.getApiURL());
            httpPost.setHeader("ApiToken", a501ClientRequestModel.getApiToken());
            httpPost.setHeader("Cluster", a501ClientRequestModel.getCluster());
            if (!BaseAPIWebClient.IsNullOrEmpty(a501ClientRequestModel.getCsrfToken())) {
                httpPost.setHeader("CSRF", a501ClientRequestModel.getCsrfToken());
                httpPost.setHeader("XsrfToken", a501ClientRequestModel.getCsrfToken());
            }
            StringEntity stringEntity = new StringEntity(data);
            httpPost.setEntity((HttpEntity)stringEntity);
            ProxySetting proxySetting = a501ClientRequestModel.getProxySetting();
            if (proxySetting != null && !BaseAPIWebClient.IsNullOrEmpty(proxySetting.getProxyHostName()) && proxySetting.getProxyPort() != null) {
                HttpHost proxy = new HttpHost(proxySetting.getProxyHostName(), proxySetting.getProxyPort().intValue());
                httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                BasicHttpContext context = new BasicHttpContext();
                if (!BaseAPIWebClient.IsNullOrEmpty(proxySetting.getProxyPassword()) && !BaseAPIWebClient.IsNullOrEmpty(proxySetting.getProxyUserName())) {
                    AuthScope authScope = new AuthScope(proxySetting.getProxyHostName(), proxySetting.getProxyPort().intValue());
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxySetting.getProxyUserName(), proxySetting.getProxyPassword());
                    context.setAttribute("http.auth.proxy-scope", (Object)authScope);
                    context.setAttribute("http.auth.credentials", (Object)credentials);
                }
                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
                responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            } else {
                HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                responseContent = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return responseContent;
    }
}

