/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

import io.github.tuzon.projects.core.base.ObjectBase;
import io.github.tuzon.projects.core.expections.FileNotDeletedException;
import io.github.tuzon.projects.core.expections.InvalidValueException;
import io.github.tuzon.projects.core.utils.ListUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class FileUtil
extends ObjectBase {
    private FileUtil() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static String getFileNameFromPath(String path) throws InvalidValueException {
        FileUtil.validateNotNull(path);
        int index = FileUtil.getLastSlashIndex(path);
        if (index == -1) {
            return path;
        }
        if (index == path.length() - 1) {
            return "";
        }
        return path.substring(index + 1);
    }

    public static String getParentDirectory(String path) throws InvalidValueException {
        FileUtil.validateNotNull(path);
        if (path.isEmpty()) {
            return "";
        }
        int index = FileUtil.getLastSlashIndex(path);
        if (index == -1) {
            return "";
        }
        if (index == path.length() - 1) {
            path = path.substring(0, index);
            return FileUtil.getParentDirectory(path);
        }
        return path.substring(0, index);
    }

    public static void deleteOldFiles(String directory, int olderInDays) throws FileNotDeletedException {
        File folder = new File(directory);
        File[] fileArr = folder.listFiles();
        if (fileArr == null) {
            return;
        }
        ArrayList<String> filesFailedToBeDeletedList = new ArrayList<String>();
        for (File file : fileArr) {
            long diffInMs;
            if (!file.isFile() || (diffInMs = new Date().getTime() - file.lastModified()) <= (long)olderInDays * 86400000L) continue;
            try {
                file.delete();
            }
            catch (SecurityException e) {
                filesFailedToBeDeletedList.add(file.getName());
            }
        }
        if (!filesFailedToBeDeletedList.isEmpty()) {
            throw new FileNotDeletedException(ListUtil.getMultilineStringFromList(filesFailedToBeDeletedList));
        }
    }

    public static List<String> getFileList(String directory, String[] extensionArr) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        File folder = new File(directory);
        File[] fileArr = folder.listFiles();
        if (fileArr == null) {
            return fileNameList;
        }
        for (File file : fileArr) {
            if (!file.isFile()) continue;
            fileNameList.add(FileUtil.getFileNameContainExtension(file.getName(), extensionArr));
        }
        fileNameList.removeAll(Arrays.asList(null, ""));
        return fileNameList;
    }

    private static String getFileNameContainExtension(String filename, String[] extensionArr) {
        if ((filename = filename.trim()).indexOf(".") > 0 && filename.indexOf(".") < filename.length() - 1) {
            for (String extension : extensionArr) {
                int index = filename.indexOf("." + extension);
                if (index <= 0) continue;
                return filename;
            }
        }
        return null;
    }

    private static int getLastSlashIndex(String path) {
        return Math.max(path.lastIndexOf("/"), path.lastIndexOf("\\"));
    }
}

