/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

import io.github.tuzon.projects.core.base.ObjectBase;
import io.github.tuzon.projects.core.expections.InvalidValueException;
import io.github.tuzon.projects.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class ListUtil
extends ObjectBase {
    private ListUtil() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static <T> List<T> getContainList(List<T> list, List<T> containList) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : list) {
            if (!containList.contains(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static <T> List<T> getNotContainList(List<T> list, List<T> containList) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : list) {
            if (containList.contains(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static <T> List<T> asList(T[] array, int startIndex) throws InvalidValueException {
        ListUtil.validateNotNull(array);
        ListUtil.validateNotNegative(startIndex);
        ArrayList<T> result = new ArrayList<T>();
        for (int i = startIndex; i < array.length; ++i) {
            result.add(array[i]);
        }
        return result;
    }

    public static <T> List<T> removeDuplication(List<T> list) throws InvalidValueException {
        ListUtil.validateNotNull(list);
        ArrayList<T> uniqueList = new ArrayList<T>();
        for (T obj : list) {
            if (uniqueList.contains(obj)) continue;
            uniqueList.add(obj);
        }
        return uniqueList;
    }

    public static <T> String getMultilineStringFromList(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T obj : list) {
            sb.append(obj.toString()).append("\n");
        }
        String result = sb.toString();
        if (!result.isEmpty()) {
            result = StringUtil.removeLastChar(result);
        }
        return result;
    }

    public static <T> List<T> asList(T ... args) {
        ArrayList<T> result = new ArrayList<T>();
        for (T arg : args) {
            result.add(arg);
        }
        return result;
    }

    public static <T> List<T> clone(List<T> list) {
        ArrayList<T> result = new ArrayList<T>();
        for (T member : list) {
            result.add(member);
        }
        return result;
    }
}

