/*
 * Decompiled with CFR 0.152.
 */
package io.github.tuzon.projects.core.utils;

import org.apache.commons.lang3.StringUtils;

public final class UrlUtil {
    private UrlUtil() {
        throw new UnsupportedOperationException("Util cannot be instantiated");
    }

    public static String getHostFromUrl(String url) {
        url = UrlUtil.subUrlPrefix(url);
        url = UrlUtil.subUrlSlash(url);
        url = UrlUtil.subUrlColon(url);
        return url;
    }

    private static String subUrlPrefix(String url) {
        String URL_PREFIX = "://";
        int index = url.indexOf("://");
        if (index > 0 && (index += "://".length()) < url.length()) {
            return url.substring(index);
        }
        return url;
    }

    private static String subUrlSlash(String url) {
        return StringUtils.substringBefore((String)url, (String)"/");
    }

    private static String subUrlColon(String url) {
        return StringUtils.substringBefore((String)url, (String)":");
    }
}

