/*
 * Decompiled with CFR 0.152.
 */
package io.github.vyaslav.kadmin;

import io.github.vyaslav.kadmin.KadminCommand;
import io.github.vyaslav.kadmin.KadminCommandResult;
import io.github.vyaslav.kadmin.KadminCommandResultParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KadminCommandsRunner {
    final Logger log = LoggerFactory.getLogger(KadminCommandsRunner.class);
    private final String principal;
    private final String keytab;
    private final String krb5ConfigPath;

    public KadminCommandsRunner(String principal, String keytab, String krb5ConfigPath) {
        this.principal = principal;
        this.keytab = keytab;
        this.krb5ConfigPath = krb5ConfigPath;
    }

    public KadminCommandResult runCommand(KadminCommand command) throws IOException {
        try (KadminProccess kAdmin = new KadminProccess(command);){
            int status = kAdmin.waitFor();
            String output = new BufferedReader(new InputStreamReader(kAdmin.getInputStream())).lines().collect(Collectors.joining("\n"));
            KadminCommandResult kadminCommandResult = KadminCommandResultParser.parse(status, output);
            return kadminCommandResult;
        }
    }

    private class KadminProccess
    implements AutoCloseable {
        private final Process kAdmin;

        public KadminProccess(KadminCommand command) throws IOException {
            ProcessBuilder processBuilder = new ProcessBuilder("kadmin", "-p", KadminCommandsRunner.this.principal, "-kt", KadminCommandsRunner.this.keytab, "-q", command.commandString()).directory(new File("/usr/bin")).redirectErrorStream(true);
            processBuilder.environment().put("KRB5_CONFIG", KadminCommandsRunner.this.krb5ConfigPath);
            this.kAdmin = processBuilder.start();
            this.kAdmin.onExit().thenAccept(process -> KadminCommandsRunner.this.log.info("stopped kadmin {}, exit value: {}", (Object)process.pid(), (Object)process.exitValue()));
            KadminCommandsRunner.this.log.info("Kadmin process PID: {} has started", (Object)this.kAdmin.pid());
        }

        public int waitFor() {
            try {
                return this.kAdmin.waitFor();
            }
            catch (InterruptedException e) {
                return this.kAdmin.exitValue();
            }
        }

        public InputStream getInputStream() {
            return this.kAdmin.getInputStream();
        }

        @Override
        public void close() throws IOException {
            if (!this.destroy()) {
                this.kAdmin.destroyForcibly();
            }
        }

        private boolean destroy() {
            this.kAdmin.destroy();
            try {
                return this.kAdmin.waitFor(10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
    }
}

