/*
 * Decompiled with CFR 0.152.
 */
package io.woo.htmltopdf;

import io.woo.htmltopdf.ObjectErrorHandling;
import io.woo.htmltopdf.WkValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class HtmlToPdfObject {
    private final Map<String, String> settings;
    private final String htmlData;
    private final Map<String, String> cookies = new HashMap<String, String>();

    public static HtmlToPdfObject forHtml(String html) {
        return HtmlToPdfObject.forHtml(html, new HashMap<String, String>());
    }

    public static HtmlToPdfObject forHtml(String html, Map<String, String> settings) {
        if (html == null || html.isEmpty() || html.startsWith("\u0000")) {
            throw new IllegalArgumentException("No content specified for object.");
        }
        return new HtmlToPdfObject(html, settings);
    }

    public static HtmlToPdfObject forUrl(String url) {
        return HtmlToPdfObject.forUrl(url, new HashMap<String, String>());
    }

    public static HtmlToPdfObject forUrl(String url, Map<String, String> settings) {
        settings.put("page", url);
        return new HtmlToPdfObject(null, settings);
    }

    private HtmlToPdfObject(String htmlData, Map<String, String> settings) {
        this.settings = settings;
        this.htmlData = htmlData;
    }

    public HtmlToPdfObject showBackground(boolean background) {
        return this.setting("web.background", background);
    }

    public HtmlToPdfObject loadImages(boolean load) {
        return this.setting("web.loadImages", load);
    }

    public HtmlToPdfObject enableJavascript(boolean enable) {
        return this.setting("web.enableJavascript", enable);
    }

    public HtmlToPdfObject enableIntelligentShrinking(boolean enable) {
        return this.setting("web.enableIntelligentShrinking", enable);
    }

    public HtmlToPdfObject minimumFontSize(int size) {
        return this.setting("web.minimumFontSize", size);
    }

    public HtmlToPdfObject usePrintMediaType(boolean use) {
        return this.setting("web.printMediaType", use);
    }

    public HtmlToPdfObject defaultEncoding(String encoding) {
        return this.setting("web.defaultEncoding", encoding);
    }

    public HtmlToPdfObject userStylesheet(String urlOrPath) {
        return this.setting("web.userStyleSheet", urlOrPath);
    }

    public HtmlToPdfObject authUsername(String username) {
        return this.setting("load.username", username);
    }

    public HtmlToPdfObject authPassword(String password) {
        return this.setting("load.password", password);
    }

    public HtmlToPdfObject javascriptDelay(int delayMs) {
        return this.setting("load.jsdelay", delayMs);
    }

    public HtmlToPdfObject viewportSize(String size) {
        return this.setting("viewportSize", size);
    }

    public HtmlToPdfObject zoomFactor(float factor) {
        return this.setting("load.zoomFactor", Float.valueOf(factor));
    }

    public HtmlToPdfObject blockLocalFileAccess(boolean block) {
        return this.setting("load.blockLocalFileAccess", block);
    }

    public HtmlToPdfObject stopSlowScript(boolean stop) {
        return this.setting("load.stopSlowScript", stop);
    }

    public HtmlToPdfObject debugJavascriptWarningsAndErrors(boolean debug) {
        return this.setting("load.debugJavascript", debug);
    }

    public HtmlToPdfObject handleErrors(ObjectErrorHandling errorHandling) {
        return this.setting("load.loadErrorHandling", errorHandling);
    }

    public HtmlToPdfObject headerFontSize(int size) {
        return this.setting("header.fontSize", size);
    }

    public HtmlToPdfObject headerFontName(String fontName) {
        return this.setting("header.fontName", fontName);
    }

    public HtmlToPdfObject headerLine(boolean line) {
        return this.setting("header.line", line);
    }

    public HtmlToPdfObject headerSpacing(int spacing) {
        return this.setting("header.spacing", spacing);
    }

    public HtmlToPdfObject headerHtmlUrl(String url) {
        return this.setting("header.htmlUrl", url);
    }

    public HtmlToPdfObject headerLeft(String text) {
        return this.setting("header.left", text);
    }

    public HtmlToPdfObject headerCenter(String text) {
        return this.setting("header.center", text);
    }

    public HtmlToPdfObject headerRight(String text) {
        return this.setting("header.right", text);
    }

    public HtmlToPdfObject footerFontSize(int size) {
        return this.setting("footer.fontSize", size);
    }

    public HtmlToPdfObject footerFontName(String fontName) {
        return this.setting("footer.fontName", fontName);
    }

    public HtmlToPdfObject footerLine(boolean line) {
        return this.setting("footer.line", line);
    }

    public HtmlToPdfObject footerSpacing(int spacing) {
        return this.setting("footer.spacing", spacing);
    }

    public HtmlToPdfObject footerHtmlUrl(String url) {
        return this.setting("footer.htmlUrl", url);
    }

    public HtmlToPdfObject footerLeft(String text) {
        return this.setting("footer.left", text);
    }

    public HtmlToPdfObject footerCenter(String text) {
        return this.setting("footer.center", text);
    }

    public HtmlToPdfObject footerRight(String text) {
        return this.setting("footer.right", text);
    }

    public HtmlToPdfObject tableOfContentsDottedLines(boolean dottedLines) {
        return this.setting("toc.useDottedLines", dottedLines);
    }

    public HtmlToPdfObject tableOfContentsCaptionText(String captionText) {
        return this.setting("toc.captionText", captionText);
    }

    public HtmlToPdfObject tableOfContentsForwardLinks(boolean forward) {
        return this.setting("toc.forwardLinks", forward);
    }

    public HtmlToPdfObject tableOfContentsBackLinks(boolean backLinks) {
        return this.setting("toc.backLinks", backLinks);
    }

    public HtmlToPdfObject tableOfContentsIndentation(String indentation) {
        return this.setting("toc.indentation", indentation);
    }

    public HtmlToPdfObject tableOfContentsIndentationFontScaleDown(float scale) {
        return this.setting("toc.fontScale", Float.valueOf(scale));
    }

    public HtmlToPdfObject tableOfContentsIncludeSections(boolean include) {
        return this.setting("includeInOutline", include);
    }

    public HtmlToPdfObject useExternalLinks(boolean use) {
        return this.setting("useExternalLinks", use);
    }

    public HtmlToPdfObject convertInternalLinksToPdfReferences(boolean convert) {
        return this.setting("useLocalLinks", convert);
    }

    public HtmlToPdfObject produceForms(boolean produce) {
        return this.setting("produceForms", produce);
    }

    public HtmlToPdfObject pageCount(boolean pageCount) {
        return this.setting("pagesCount", pageCount);
    }

    public HtmlToPdfObject cacheDir(String path) {
        return this.setting("load.cacheDir", path);
    }

    public HtmlToPdfObject cookie(String name, String value) {
        if (name != null && value != null) {
            try {
                String encodedValue = URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
                this.cookies.put(name, encodedValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to encode cookie value", e);
            }
        }
        return this;
    }

    public HtmlToPdfObject cookies(Map<String, String> cookies) {
        if (cookies != null) {
            cookies.forEach(this::cookie);
        }
        return this;
    }

    private HtmlToPdfObject setting(String name, Object value) {
        return this.setting(name, value.toString());
    }

    private HtmlToPdfObject setting(String name, WkValue value) {
        return this.setting(name, value.getWkValue());
    }

    private HtmlToPdfObject setting(String name, String value) {
        this.settings.put(name, value);
        return this;
    }

    Map<String, String> getSettings() {
        return this.settings;
    }

    String getHtmlData() {
        return this.htmlData;
    }

    Map<String, String> getCookies() {
        return this.cookies;
    }
}

