/*
 * Decompiled with CFR 0.152.
 */
package io.github.xanthic.cache.springjdk17;

import io.github.xanthic.cache.core.CacheApi;
import io.github.xanthic.cache.core.CacheApiSpec;
import io.github.xanthic.cache.springjdk17.CacheWrapper;
import io.github.xanthic.cache.springjdk17.XanthicSpringCache;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.lang.Nullable;

public class XanthicSpringCacheManager
implements CacheManager {
    private final Map<String, CacheWrapper> cacheMap = new ConcurrentHashMap<String, CacheWrapper>();
    private final Consumer<CacheApiSpec<Object, Object>> spec;
    private final boolean dynamic;

    public XanthicSpringCacheManager(Consumer<CacheApiSpec<Object, Object>> spec) {
        this.spec = spec;
        this.dynamic = true;
    }

    public XanthicSpringCacheManager(Consumer<CacheApiSpec<Object, Object>> spec, @Nullable Collection<String> cacheNames) {
        this.spec = spec;
        if (cacheNames != null) {
            this.dynamic = false;
            for (String name : cacheNames) {
                this.cacheMap.put(name, new CacheWrapper(this.createCache(name, this.spec)));
            }
        } else {
            this.dynamic = true;
        }
    }

    @Nullable
    public Cache getCache(@NotNull String name) {
        CacheWrapper optimistic = this.cacheMap.get(name);
        if (optimistic != null) {
            return optimistic.cache();
        }
        if (!this.dynamic) {
            return null;
        }
        return this.cacheMap.computeIfAbsent(name, cacheName -> new CacheWrapper(this.createCache((String)cacheName, this.spec))).cache();
    }

    @NotNull
    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheMap.keySet());
    }

    @Deprecated
    @NotNull
    @VisibleForTesting
    public Set<String> getCustomCacheNames() {
        HashSet names = new HashSet();
        this.cacheMap.forEach((k, v) -> {
            if (v.custom()) {
                names.add(k);
            }
        });
        return Collections.unmodifiableSet(names);
    }

    public void registerCache(String name, Consumer<CacheApiSpec<Object, Object>> spec) {
        if (!this.dynamic) {
            throw new IllegalStateException("CacheManager has a fixed set of cache keys and does not allow creation of new caches.");
        }
        this.cacheMap.put(name, new CacheWrapper(this.createCache(name, spec), true));
    }

    public void removeCache(String name) {
        if (!this.dynamic) {
            throw new IllegalStateException("CacheManager has a fixed set of cache keys and does not allow removal of existing caches.");
        }
        this.cacheMap.remove(name);
    }

    private Cache createCache(String name, Consumer<CacheApiSpec<Object, Object>> spec) {
        return new XanthicSpringCache(name, (io.github.xanthic.cache.api.Cache<Object, Object>)CacheApi.create(spec));
    }
}

