/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.HttpClient;
import io.intercom.api.TypedData;
import io.intercom.api.TypedDataCollectionIterator;
import io.intercom.api.UriBuilder;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(value={"page"}, ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class TypedDataCollection<T extends TypedData>
extends TypedData
implements Iterator<T> {
    public static final String NEXT_PAGE_REL = "next";
    protected List<T> page = Lists.newArrayList();
    @JsonProperty(value="pages")
    protected Map<String, URI> pages = Maps.newHashMap();
    @JsonProperty(value="type")
    protected String type;
    private TypedDataCollectionIterator<T> iterator = new TypedDataCollectionIterator(this);

    public abstract TypedDataCollection<T> nextPage();

    public boolean hasNextPage() {
        return this.pages.containsKey(NEXT_PAGE_REL) && this.pages.get(NEXT_PAGE_REL) != null;
    }

    public List<T> getPage() {
        return ImmutableList.builder().addAll(this.page).build();
    }

    protected <C extends TypedDataCollection<T>> C fetchNextPage(Class<C> typeReference) {
        if (this.hasNextPage()) {
            URI next = UriBuilder.newBuilder(this.pages.get(NEXT_PAGE_REL)).build();
            HttpClient resource = new HttpClient(next);
            return (C)((TypedDataCollection)resource.get(typeReference));
        }
        return null;
    }

    public Map<String, URI> getPages() {
        return ImmutableMap.builder().putAll(this.pages).build();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedDataCollection that = (TypedDataCollection)o;
        if (this.page != null ? !this.page.equals(that.page) : that.page != null) {
            return false;
        }
        if (this.pages != null ? !this.pages.equals(that.pages) : that.pages != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.page != null ? this.page.hashCode() : 0;
        result = 31 * result + (this.pages != null ? this.pages.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getType() + "{page=" + this.page + "} " + super.toString();
    }
}

