/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.ebean;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.ebean.Database;
import io.ebean.DatabaseFactory;
import io.ebean.config.DatabaseConfig;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;

public class EbeanModule
implements Extension {
    private final String name;
    private final DatabaseConfig databaseConfig;

    public EbeanModule(@NonNull String name) {
        this.name = name;
        this.databaseConfig = null;
    }

    public EbeanModule() {
        this("db");
    }

    public EbeanModule(@NonNull DatabaseConfig config) {
        this.databaseConfig = config;
        this.name = this.databaseConfig.getName();
    }

    public void install(@NonNull Jooby application) throws Exception {
        DatabaseConfig config = Optional.ofNullable(this.databaseConfig).orElseGet(() -> EbeanModule.create(application, this.name));
        Database database = DatabaseFactory.create((DatabaseConfig)config);
        ServiceRegistry services = application.getServices();
        services.putIfAbsent(Database.class, (Object)database);
        services.put(ServiceKey.key(Database.class, (String)this.name), (Object)database);
    }

    @NonNull
    public static DatabaseConfig create(@NonNull Jooby application, @NonNull String name) {
        Environment environment = application.getEnvironment();
        ServiceRegistry registry = application.getServices();
        DatabaseConfig databaseConfig = new DatabaseConfig();
        Properties properties = new Properties();
        Config config = environment.getConfig();
        Config ebean = EbeanModule.config(config, "ebean." + name).withFallback((ConfigMergeable)EbeanModule.config(config, "ebean"));
        ebean.entrySet().forEach(e -> properties.put(e.getKey(), ((ConfigValue)e.getValue()).unwrapped().toString()));
        databaseConfig.loadFromProperties(properties);
        if (!ebean.hasPath("datasource")) {
            DataSource dataSource = (DataSource)registry.getOrNull(ServiceKey.key(DataSource.class, (String)name));
            if (dataSource == null) {
                dataSource = (DataSource)registry.get(DataSource.class);
            }
            databaseConfig.setDataSource(dataSource);
        }
        return databaseConfig;
    }

    private static Config config(Config config, String name) {
        if (config.hasPath(name) && config.getValue(name).valueType() == ConfigValueType.OBJECT) {
            return config.getConfig(name);
        }
        return ConfigFactory.empty();
    }
}

