/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.vertx.sqlclient;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.internal.vertx.sqlclient.VertxThreadLocalPreparedObject;
import io.vertx.core.Future;
import io.vertx.core.impl.VertxThread;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

public record VertxPreparedQueryProxy(String name) implements PreparedQuery<RowSet<Row>>
{
    private PreparedQuery<RowSet<Row>> get() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof VertxThread)) {
            throw new IllegalStateException("Current thread is not a vertx thread");
        }
        return (PreparedQuery)VertxThreadLocalPreparedObject.get(this.name).get(0);
    }

    @Override
    @NonNull
    public String toString() {
        return Thread.currentThread().getName() + ":" + this.name;
    }

    public Future<RowSet<Row>> execute() {
        return this.get().execute();
    }

    public Future<RowSet<Row>> execute(Tuple tuple) {
        return this.get().execute(tuple);
    }

    public Future<RowSet<Row>> executeBatch(List<Tuple> batch) {
        return this.get().executeBatch(batch);
    }

    public <R> PreparedQuery<SqlResult<R>> collecting(Collector<Row, ?, R> collector) {
        return this.get().collecting(collector);
    }

    public <U> PreparedQuery<RowSet<U>> mapping(Function<Row, U> mapper) {
        return this.get().mapping(mapper);
    }
}

