/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.vertx.sqlclient;

import io.jooby.internal.vertx.sqlclient.VertxThreadLocalPreparedObject;
import io.jooby.internal.vertx.sqlclient.VertxThreadLocalSqlConnection;
import io.vertx.core.Future;
import io.vertx.core.VerticleBase;
import io.vertx.core.Vertx;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiFunction;

public class VertxSqlConnectionVerticle<Connection extends SqlConnection, Options extends SqlConnectOptions>
extends VerticleBase {
    private final BiFunction<Vertx, Options, Future<Connection>> factory;
    private final Options options;
    private final Map<String, List<String>> preparedStatements;
    private Connection connection;

    public VertxSqlConnectionVerticle(BiFunction<Vertx, Options, Future<Connection>> factory, Options options, Map<String, List<String>> preparedStatements) {
        this.factory = factory;
        this.options = options;
        this.preparedStatements = preparedStatements;
    }

    public Future<?> stop() {
        return this.connection.close();
    }

    public Future<?> start() {
        return this.factory.apply(this.vertx, this.options).transform(ar -> {
            if (ar.succeeded()) {
                this.connection = (SqlConnection)ar.result();
                VertxThreadLocalSqlConnection.set(this.options.getDatabase(), this.connection);
                ArrayList futures = new ArrayList();
                this.preparedStatements.forEach((key, sqlList) -> {
                    TreeMap compiled = new TreeMap();
                    int size = sqlList.size();
                    for (int i = 0; i < size; ++i) {
                        int order = i;
                        futures.add(this.connection.prepare((String)sqlList.get(i)).onSuccess(result -> {
                            compiled.put(order, result);
                            if (compiled.size() == size) {
                                List statementList = compiled.values().stream().toList();
                                List<PreparedQuery> queryList = statementList.stream().map(PreparedStatement::query).toList();
                                VertxThreadLocalPreparedObject.set(key, statementList);
                                VertxThreadLocalPreparedObject.set(key + ".query", queryList);
                            }
                        }));
                    }
                });
                return Future.all(futures);
            }
            return Future.failedFuture((Throwable)ar.cause());
        });
    }
}

