/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.vertx.sqlclient;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.internal.vertx.sqlclient.VertxPreparedQueryProxy;
import io.jooby.internal.vertx.sqlclient.VertxThreadLocalPreparedObject;
import io.vertx.core.Future;
import io.vertx.core.impl.VertxThread;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.RowStream;
import io.vertx.sqlclient.Tuple;

public record VertxPreparedStatementProxy(String name) implements PreparedStatement
{
    private PreparedStatement get() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof VertxThread)) {
            throw new IllegalStateException("Current thread is not a vertx thread");
        }
        return (PreparedStatement)VertxThreadLocalPreparedObject.get(this.name).get(0);
    }

    public PreparedQuery<RowSet<Row>> query() {
        return new VertxPreparedQueryProxy(this.name + ".query");
    }

    public Cursor cursor() {
        return this.get().cursor();
    }

    public Cursor cursor(Tuple args) {
        return this.get().cursor(args);
    }

    public RowStream<Row> createStream(int fetch) {
        return this.get().createStream(fetch);
    }

    public RowStream<Row> createStream(int fetch, Tuple args) {
        return this.get().createStream(fetch, args);
    }

    public Future<Void> close() {
        return this.get().close();
    }

    @Override
    @NonNull
    public String toString() {
        return Thread.currentThread().getName() + ":" + this.name;
    }
}

