/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.vertx.sqlclient;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.ClientBuilder;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;

public abstract class VertxSqlClientModule
implements Extension {
    private final String name;

    public VertxSqlClientModule(@NonNull String name) {
        this.name = name;
    }

    public void install(@NonNull Jooby application) throws Exception {
        ServiceRegistry registry = application.getServices();
        Config config = application.getConfig();
        ConfigValue configOptions = config.getValue(this.name);
        SqlConnectOptions options = configOptions.valueType() == ConfigValueType.STRING ? this.fromUri(config.getString(this.name)) : this.fromMap(new JsonObject(config.getObject(this.name).unwrapped()));
        SqlClient client = (SqlClient)this.newBuilder().connectingTo(options).using((Vertx)registry.require(Vertx.class)).build();
        registry.put(ServiceKey.key(SqlClient.class, (String)this.name), (Object)client);
        registry.putIfAbsent(SqlClient.class, (Object)client);
        if (client instanceof Pool) {
            Pool pool = (Pool)client;
            registry.put(ServiceKey.key(Pool.class, (String)this.name), (Object)pool);
            registry.putIfAbsent(Pool.class, (Object)pool);
        }
        application.onStop(() -> client.close().await());
    }

    protected abstract SqlConnectOptions fromMap(JsonObject var1);

    protected abstract SqlConnectOptions fromUri(String var1);

    protected abstract ClientBuilder<? extends SqlClient> newBuilder();
}

