/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.vertx.sqlclient;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.VertxThread;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.PreparedStatement;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.Transaction;
import io.vertx.sqlclient.impl.SqlClientInternal;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import io.vertx.sqlclient.spi.Driver;
import java.util.HashMap;
import java.util.Map;

public record VertxThreadLocalSqlConnection(String name) implements SqlConnection,
SqlClientInternal
{
    private static final ThreadLocal<Map<String, SqlConnection>> connectionHolder = ThreadLocal.withInitial(HashMap::new);

    public static SqlConnection get(String name) {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof VertxThread)) {
            throw new IllegalStateException("Current thread is not a vertx thread");
        }
        return connectionHolder.get().get(name);
    }

    public static <T extends SqlConnection> void set(String name, T connection) {
        connectionHolder.get().put(name, connection);
    }

    private SqlConnection get() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof VertxThread)) {
            throw new IllegalStateException("Current thread is not a vertx thread");
        }
        return VertxThreadLocalSqlConnection.get(this.name);
    }

    public Driver driver() {
        return ((SqlClientInternal)this.get()).driver();
    }

    public void group(Handler<SqlClient> block) {
        ((SqlClientInternal)this.get()).group(block);
    }

    public Query<RowSet<Row>> query(String sql) {
        return this.get().query(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        return this.get().preparedQuery(sql);
    }

    public PreparedQuery<RowSet<Row>> preparedQuery(String sql, PrepareOptions options) {
        return this.get().preparedQuery(sql, options);
    }

    public Future<Void> close() {
        return this.get().close();
    }

    @Override
    @NonNull
    public String toString() {
        return Thread.currentThread().getName() + ":" + this.name;
    }

    public Future<PreparedStatement> prepare(String sql) {
        return this.get().prepare(sql);
    }

    public Future<PreparedStatement> prepare(String sql, PrepareOptions options) {
        return this.get().prepare(sql, options);
    }

    public SqlConnection exceptionHandler(Handler<Throwable> handler) {
        return this.get().exceptionHandler(handler);
    }

    public SqlConnection closeHandler(Handler<Void> handler) {
        return this.get().closeHandler(handler);
    }

    public Future<Transaction> begin() {
        return this.get().begin();
    }

    public Transaction transaction() {
        return this.get().transaction();
    }

    public boolean isSSL() {
        return this.get().isSSL();
    }

    public DatabaseMetadata databaseMetadata() {
        return this.get().databaseMetadata();
    }
}

