/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client;

import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.LoadBalancer;
import io.reactivesocket.client.ReactiveSocketClient;
import io.reactivesocket.events.AbstractEventSource;
import io.reactivesocket.events.ClientEventListener;
import io.reactivesocket.internal.EventPublisher;
import io.reactivesocket.reactivestreams.extensions.Px;
import io.reactivesocket.reactivestreams.extensions.internal.ValidatingSubscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class LoadBalancerInitializer
extends AbstractEventSource<ClientEventListener>
implements Runnable {
    private volatile LoadBalancer loadBalancer;
    private final Publisher<ReactiveSocket> emitSource;
    private boolean ready;
    private boolean created;
    private final List<Subscriber<? super ReactiveSocket>> earlySubscribers = new CopyOnWriteArrayList<Subscriber<? super ReactiveSocket>>();

    private LoadBalancerInitializer(Publisher<? extends Collection<ReactiveSocketClient>> factories) {
        this.emitSource = s -> {
            boolean _emit;
            boolean _create;
            LoadBalancerInitializer loadBalancerInitializer = this;
            synchronized (loadBalancerInitializer) {
                _create = !this.created;
                _emit = this.ready;
                if (!_emit) {
                    this.earlySubscribers.add((Subscriber<? super ReactiveSocket>)s);
                }
                if (!this.created) {
                    this.created = true;
                }
            }
            if (_create) {
                this.loadBalancer = new LoadBalancer(factories, this, (EventPublisher<ClientEventListener>)this);
            }
            if (_emit) {
                s.onSubscribe((Subscription)ValidatingSubscription.empty((Subscriber)s));
                s.onNext((Object)this.loadBalancer);
                s.onComplete();
            }
        };
    }

    static LoadBalancerInitializer create(Publisher<? extends Collection<ReactiveSocketClient>> factories) {
        return new LoadBalancerInitializer(factories);
    }

    Publisher<ReactiveSocket> connect() {
        return this.emitSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Subscriber<? super ReactiveSocket>> earlySubs;
        LoadBalancerInitializer loadBalancerInitializer = this;
        synchronized (loadBalancerInitializer) {
            if (this.ready) {
                return;
            }
            earlySubs = new ArrayList<Subscriber<? super ReactiveSocket>>(this.earlySubscribers);
            this.earlySubscribers.clear();
            this.ready = true;
        }
        Px source = Px.just((Object)this.loadBalancer);
        for (Subscriber subscriber : earlySubs) {
            source.subscribe(subscriber);
        }
    }

    synchronized double availability() {
        return this.ready ? 1.0 : 0.0;
    }
}

