/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client.events;

import io.reactivesocket.Availability;
import io.reactivesocket.client.events.LoadBalancingClientListener;
import io.reactivesocket.events.LoggingClientEventListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.event.Level;

public class LoggingLoadBalancingClientListener
extends LoggingClientEventListener
implements LoadBalancingClientListener {
    public LoggingLoadBalancingClientListener(String name, Level logLevel) {
        super(name, logLevel);
    }

    @Override
    public void socketAdded(Availability availability) {
        this.logIfEnabled(() -> this.name + ": socketAdded availability = [" + availability + ']');
    }

    @Override
    public void socketRemoved(Availability availability) {
        this.logIfEnabled(() -> this.name + ": socketRemoved availability = [" + availability + ']');
    }

    @Override
    public void serverAdded(Availability availability) {
        this.logIfEnabled(() -> this.name + ": serverAdded availability = [" + availability + ']');
    }

    @Override
    public void serverRemoved(Availability availability) {
        this.logIfEnabled(() -> this.name + ": serverRemoved availability = [" + availability + ']');
    }

    @Override
    public void apertureChanged(int oldAperture, int newAperture) {
        this.logIfEnabled(() -> this.name + ": apertureChanged oldAperture = [" + oldAperture + "newAperture = [" + newAperture + ']');
    }

    @Override
    public void socketRefreshPeriodChanged(long oldPeriod, long newPeriod, TimeUnit periodUnit) {
        this.logIfEnabled(() -> this.name + ": socketRefreshPeriodChanged newPeriod = [" + newPeriod + "], periodUnit = [" + (Object)((Object)periodUnit) + ']');
    }

    @Override
    public void socketsRefreshStart() {
        this.logIfEnabled(() -> this.name + ": socketsRefreshStart");
    }

    @Override
    public void socketsRefreshCompleted(long duration, TimeUnit durationUnit) {
        this.logIfEnabled(() -> this.name + ": socketsRefreshCompleted duration = [" + duration + "], durationUnit = [" + (Object)((Object)durationUnit) + ']');
    }
}

