/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client.filter;

import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.AbstractReactiveSocketClient;
import io.reactivesocket.client.ReactiveSocketClient;
import io.reactivesocket.events.EventSource;
import io.reactivesocket.reactivestreams.extensions.Px;
import io.reactivesocket.stat.Ewma;
import io.reactivesocket.util.Clock;
import io.reactivesocket.util.ReactiveSocketDecorator;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public class FailureAwareClient
extends AbstractReactiveSocketClient {
    private static final double EPSILON = 1.0E-4;
    private final ReactiveSocketClient delegate;
    private final long tau;
    private long stamp;
    private final Ewma errorPercentage;

    public FailureAwareClient(ReactiveSocketClient delegate, long halfLife, TimeUnit unit) {
        super((EventSource)delegate);
        this.delegate = delegate;
        this.tau = Clock.unit().convert((long)((double)halfLife / Math.log(2.0)), unit);
        this.stamp = Clock.now();
        this.errorPercentage = new Ewma(halfLife, unit, 1.0);
    }

    public FailureAwareClient(ReactiveSocketClient delegate) {
        this(delegate, 5L, TimeUnit.SECONDS);
    }

    public Publisher<? extends ReactiveSocket> connect() {
        return Px.from((Publisher)this.delegate.connect()).doOnNext(o -> this.updateErrorPercentage(1.0)).doOnError(t -> this.updateErrorPercentage(0.0)).map(socket -> ReactiveSocketDecorator.wrap((ReactiveSocket)socket).availability(delegate -> {
            if (Clock.now() - this.stamp > this.tau) {
                this.updateErrorPercentage(1.0);
            }
            return delegate.availability() * this.errorPercentage.value();
        }).decorateAllResponses(this._record()).decorateAllVoidResponses(this._record()).finish());
    }

    public double availability() {
        double e = this.errorPercentage.value();
        if (Clock.now() - this.stamp > this.tau) {
            double a = Math.min(1.0, e + 0.5);
            this.errorPercentage.reset(a);
        }
        if (e < 1.0E-4) {
            e = 0.0;
        } else if (0.9999 < e) {
            e = 1.0;
        }
        return e;
    }

    private synchronized void updateErrorPercentage(double value) {
        this.errorPercentage.insert(value);
        this.stamp = Clock.now();
    }

    private <T> Function<Publisher<T>, Publisher<T>> _record() {
        return t -> Px.from((Publisher)t).doOnError(th -> this.errorPercentage.insert(0.0)).doOnComplete(() -> this.updateErrorPercentage(1.0));
    }

    public String toString() {
        return "FailureAwareClient(" + this.errorPercentage.value() + ")->" + this.delegate;
    }
}

