/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client.filter;

import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.AbstractReactiveSocketClient;
import io.reactivesocket.client.ReactiveSocketClient;
import io.reactivesocket.client.filter.FailureAwareClient;
import io.reactivesocket.events.EventSource;
import io.reactivesocket.reactivestreams.extensions.Px;
import io.reactivesocket.reactivestreams.extensions.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.reactivestreams.Publisher;

public final class ReactiveSocketClients {
    private ReactiveSocketClients() {
    }

    public static ReactiveSocketClient connectTimeout(final ReactiveSocketClient orig, final long timeout, final TimeUnit unit, final Scheduler scheduler) {
        return new AbstractReactiveSocketClient((EventSource)orig){

            public Publisher<? extends ReactiveSocket> connect() {
                return Px.from((Publisher)orig.connect()).timeout(timeout, unit, scheduler);
            }

            public double availability() {
                return orig.availability();
            }
        };
    }

    public static ReactiveSocketClient detectFailures(ReactiveSocketClient orig) {
        return new FailureAwareClient(orig);
    }

    public static ReactiveSocketClient wrap(final ReactiveSocketClient orig, final Function<ReactiveSocket, ReactiveSocket> mapper) {
        return new AbstractReactiveSocketClient((EventSource)orig){

            public Publisher<? extends ReactiveSocket> connect() {
                return Px.from((Publisher)orig.connect()).map(mapper::apply);
            }

            public double availability() {
                return orig.availability();
            }
        };
    }
}

