/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.handles.LoopHandle;
import java.io.Closeable;
import java.util.Objects;

public abstract class Handle
implements Closeable {
    protected final long pointer;
    protected final LoopHandle loop;

    protected Handle(long pointer, LoopHandle loop) {
        Objects.requireNonNull(loop);
        assert (pointer != 0L);
        this.pointer = pointer;
        this.loop = loop;
    }

    public void ref() {
        this._ref(this.pointer);
    }

    public void unref() {
        this._unref(this.pointer);
    }

    public boolean isClosing() {
        return this._closing(this.pointer);
    }

    public int hashCode() {
        return (int)(this.pointer & 0xFFFFFFFFL ^ this.pointer >> 32 & 0xFFFFFFFFL);
    }

    public boolean equals(Object other) {
        return other instanceof Handle && this.pointer == ((Handle)other).pointer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "." + Long.toHexString(this.pointer);
    }

    private native void _ref(long var1);

    private native void _unref(long var1);

    private native boolean _closing(long var1);
}

