/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv.handles;

import com.oracle.libuv.cb.AsyncCallback;
import com.oracle.libuv.cb.CallbackExceptionHandler;
import com.oracle.libuv.cb.CallbackHandler;
import com.oracle.libuv.cb.ProcessCloseCallback;
import com.oracle.libuv.cb.ProcessExitCallback;
import com.oracle.libuv.cb.StreamCloseCallback;
import com.oracle.libuv.cb.StreamConnectCallback;
import com.oracle.libuv.cb.StreamConnectionCallback;
import com.oracle.libuv.cb.StreamReadCallback;
import com.oracle.libuv.cb.StreamShutdownCallback;
import com.oracle.libuv.cb.StreamWriteCallback;
import com.oracle.libuv.cb.TimerCallback;
import java.nio.ByteBuffer;

public final class LoopCallbackHandler
implements CallbackHandler {
    private final CallbackExceptionHandler exceptionHandler;

    public LoopCallbackHandler(CallbackExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void handleAsyncCallback(AsyncCallback cb, int status) {
        try {
            cb.onSend(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamReadCallback(StreamReadCallback cb, ByteBuffer data) {
        try {
            cb.onRead(data);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamWriteCallback(StreamWriteCallback cb, int status, Exception error) {
        try {
            cb.onWrite(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamConnectCallback(StreamConnectCallback cb, int status, Exception error) {
        try {
            cb.onConnect(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamConnectionCallback(StreamConnectionCallback cb, int status, Exception error) {
        try {
            cb.onConnection(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamCloseCallback(StreamCloseCallback cb) {
        try {
            cb.onClose();
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleStreamShutdownCallback(StreamShutdownCallback cb, int status, Exception error) {
        try {
            cb.onShutdown(status, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleProcessCloseCallback(ProcessCloseCallback cb) {
        try {
            cb.onClose();
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleProcessExitCallback(ProcessExitCallback cb, int status, int signal, Exception error) {
        try {
            cb.onExit(status, signal, error);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }

    @Override
    public void handleTimerCallback(TimerCallback cb, int status) {
        try {
            cb.onTimer(status);
        }
        catch (Exception ex) {
            this.exceptionHandler.handle(ex);
        }
    }
}

