/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.libuv;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;

public final class LibUV {
    private static boolean loaded;
    private static final String version = "1.1.0";
    private static final String OS_NAME;
    private static final Path tmpdir;
    private static final boolean WINDOWS;
    private static final boolean MAC;

    public static synchronized boolean loadJni() {
        if (loaded) {
            return true;
        }
        ClassLoader cl = LibUV.class.getClassLoader();
        String name = WINDOWS ? "uv-java.dll" : (MAC ? "libuv-java.dylib" : "libuv-java.so");
        Path libFile = tmpdir.resolve("libuv-java-1.1.0").resolve(name);
        if (!Files.exists(libFile, new LinkOption[0])) {
            try (InputStream is = cl.getResourceAsStream("META-INF/" + name);){
                if (is == null) {
                    throw new RuntimeException("resource not found: META-INF/" + name);
                }
                if (!Files.exists(libFile.getParent(), new LinkOption[0])) {
                    Files.createDirectory(libFile.getParent(), new FileAttribute[0]);
                }
                if (!Files.exists(libFile, new LinkOption[0])) {
                    Files.createFile(libFile, new FileAttribute[0]);
                }
                Files.copy(is, libFile, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        System.load(libFile.toString());
        loaded = true;
        return true;
    }

    private LibUV() {
    }

    public static String version() {
        return LibUV._version();
    }

    public static void disableStdioInheritance() {
        LibUV._disable_stdio_inheritance();
    }

    public static String exePath() {
        return LibUV._exe_path();
    }

    public static String cwd() {
        return LibUV._cwd();
    }

    public static void chdir(String dir) {
        LibUV._chdir(dir);
    }

    public static String getTitle() {
        return LibUV._getTitle();
    }

    public static void setTitle(String value) {
        Objects.requireNonNull(value);
        LibUV._setTitle(value);
    }

    public static int kill(int pid, int signal) {
        return LibUV._kill(pid, signal);
    }

    public static int rss() {
        return LibUV._rss();
    }

    public static double getUptime() {
        return LibUV._getUptime();
    }

    public static double[] getLoadAvg() {
        return LibUV._getLoadAvg();
    }

    public static double getTotalMem() {
        return LibUV._getTotalMem();
    }

    public static double getFreeMem() {
        return LibUV._getFreeMem();
    }

    public static Object[] getCPUs() {
        return LibUV._getCPUs();
    }

    public static boolean isIPv6(String ip) {
        Objects.requireNonNull(ip);
        return LibUV._isIPv6(ip);
    }

    private static native String _version();

    private static native void _disable_stdio_inheritance();

    private static native String _exe_path();

    private static native String _cwd();

    private static native void _chdir(String var0);

    private static native String _getTitle();

    private static native void _setTitle(String var0);

    private static native int _kill(int var0, int var1);

    private static native int _rss();

    private static native double _getUptime();

    private static native double[] _getLoadAvg();

    private static native double _getTotalMem();

    private static native double _getFreeMem();

    private static native Object[] _getCPUs();

    private static native boolean _isIPv6(String var0);

    static {
        OS_NAME = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        tmpdir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
        WINDOWS = OS_NAME.startsWith("windows");
        MAC = OS_NAME.contains("mac");
        LibUV.loadJni();
    }
}

