/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.utils;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.BoundingBox;
import ai.djl.modality.cv.output.DetectedObjects;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.entity.DetectionResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class DetectorUtils {
    public static DetectionResponse convertToDetectionResponse(DetectedObjects detection, Image img) {
        if (Objects.isNull(detection) || Objects.isNull(detection.getProbabilities()) || detection.getProbabilities().isEmpty() || Objects.isNull(detection.items()) || detection.items().isEmpty()) {
            return null;
        }
        DetectionResponse detectionResponse = new DetectionResponse();
        ArrayList<DetectionRectangle> rectangleList = new ArrayList<DetectionRectangle>();
        List detectedObjectList = detection.items();
        Iterator iterator = detectedObjectList.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            DetectedObjects.DetectedObject result = (DetectedObjects.DetectedObject)iterator.next();
            String className = result.getClassName();
            BoundingBox box = result.getBoundingBox();
            int x = (int)(box.getBounds().getX() * (double)img.getWidth());
            int y = (int)(box.getBounds().getY() * (double)img.getHeight());
            int width = (int)(box.getBounds().getWidth() * (double)img.getWidth());
            int height = (int)(box.getBounds().getHeight() * (double)img.getHeight());
            DetectionRectangle rectangle = new DetectionRectangle(x, y, width, height, ((Double)detection.getProbabilities().get(index)).floatValue(), className);
            rectangleList.add(rectangle);
            ++index;
        }
        detectionResponse.setRectangleList(rectangleList);
        return detectionResponse;
    }
}

