/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.objectdetection.criteria;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.translator.YoloV8TranslatorFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslatorFactory;
import ai.djl.util.Progress;
import cn.smartjavaai.objectdetection.config.DetectorModelConfig;
import cn.smartjavaai.objectdetection.criteria.CriteriaBuilderStrategy;
import java.nio.file.Paths;

public class YoloCriteriaBuilder
implements CriteriaBuilderStrategy {
    @Override
    public Criteria<Image, DetectedObjects> buildCriteria(DetectorModelConfig config) {
        Criteria.Builder criteriaBuilder = Criteria.builder().setTypes(Image.class, DetectedObjects.class).optModelPath(Paths.get(config.getModelPath(), new String[0])).optEngine("OnnxRuntime").optArgument("width", (Object)640).optArgument("height", (Object)640).optArgument("resize", (Object)true).optArgument("toTensor", (Object)true).optArgument("applyRatio", (Object)true).optTranslatorFactory((TranslatorFactory)new YoloV8TranslatorFactory()).optProgress((Progress)new ProgressBar()).optArgument("threshold", (Object)Float.valueOf(config.getThreshold() > 0.0f ? config.getThreshold() : 0.5f));
        if (config.getMaxBox() > 0) {
            criteriaBuilder.optArgument("maxBox", (Object)config.getMaxBox());
        }
        Criteria criteria = criteriaBuilder.build();
        return criteria;
    }
}

