/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.bean;

import cn.ujava.common.func.SerSupplier;
import cn.ujava.common.map.ReferenceConcurrentMap;
import cn.ujava.common.map.WeakConcurrentMap;
import java.beans.PropertyDescriptor;
import java.util.Map;

public enum BeanInfoCache {
    INSTANCE;

    private final WeakConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> pdCache = new WeakConcurrentMap();
    private final WeakConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> ignoreCasePdCache = new WeakConcurrentMap();

    public Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> beanClass, boolean ignoreCase) {
        return this.getCache(ignoreCase).get(beanClass);
    }

    public Map<String, PropertyDescriptor> getPropertyDescriptorMap(Class<?> beanClass, boolean ignoreCase, SerSupplier<Map<String, PropertyDescriptor>> supplier) {
        return this.getCache(ignoreCase).computeIfAbsent(beanClass, key -> (Map)supplier.get());
    }

    public void putPropertyDescriptorMap(Class<?> beanClass, Map<String, PropertyDescriptor> fieldNamePropertyDescriptorMap, boolean ignoreCase) {
        this.getCache(ignoreCase).put(beanClass, fieldNamePropertyDescriptorMap);
    }

    public void clear() {
        this.pdCache.clear();
        this.ignoreCasePdCache.clear();
    }

    private ReferenceConcurrentMap<Class<?>, Map<String, PropertyDescriptor>> getCache(boolean ignoreCase) {
        return ignoreCase ? this.ignoreCasePdCache : this.pdCache;
    }
}

