/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.bean;

import cn.ujava.common.bean.BeanException;
import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.PropDesc;
import cn.ujava.common.exception.CloneException;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.reflect.ClassUtil;
import cn.ujava.common.reflect.ConstructorUtil;
import cn.ujava.common.reflect.method.MethodUtil;
import java.io.Serializable;
import java.util.Map;

public class DynaBean
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Object bean;

    public static DynaBean of(Object bean) {
        return new DynaBean(bean);
    }

    public static DynaBean of(Class<?> beanClass) {
        return new DynaBean(beanClass);
    }

    public static DynaBean of(Class<?> beanClass, Object ... params) {
        return new DynaBean(beanClass, params);
    }

    public DynaBean(Class<?> beanClass, Object ... params) {
        this(ConstructorUtil.newInstance(beanClass, params));
    }

    public DynaBean(Class<?> beanClass) {
        this(ConstructorUtil.newInstance(beanClass, new Object[0]));
    }

    public DynaBean(Object bean) {
        Assert.notNull(bean);
        if (bean instanceof DynaBean) {
            bean = ((DynaBean)bean).getBean();
        }
        this.bean = bean;
        this.beanClass = ClassUtil.getClass(bean);
    }

    public <T> T get(String fieldName) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return (T)((Map)this.bean).get(fieldName);
        }
        PropDesc prop = BeanUtil.getBeanDesc(this.beanClass).getProp(fieldName);
        if (null == prop) {
            throw new BeanException("No public field or get method for {}", fieldName);
        }
        return (T)prop.getValue(this.bean);
    }

    public boolean containsProp(String fieldName) {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            return ((Map)this.bean).containsKey(fieldName);
        }
        return null != BeanUtil.getBeanDesc(this.beanClass).getProp(fieldName);
    }

    public <T> T safeGet(String fieldName) {
        try {
            return this.get(fieldName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void set(String fieldName, Object value) throws BeanException {
        if (Map.class.isAssignableFrom(this.beanClass)) {
            ((Map)this.bean).put(fieldName, value);
        } else {
            PropDesc prop = BeanUtil.getBeanDesc(this.beanClass).getProp(fieldName);
            if (null == prop) {
                throw new BeanException("No public field or set method for {}", fieldName);
            }
            prop.setValue(this.bean, value);
        }
    }

    public Object invoke(String methodName, Object ... params) {
        return MethodUtil.invoke(this.bean, methodName, params);
    }

    public <T> T getBean() {
        return (T)this.bean;
    }

    public <T> Class<T> getBeanClass() {
        return this.beanClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DynaBean other = (DynaBean)obj;
        if (this.bean == null) {
            return other.bean == null;
        }
        return this.bean.equals(other.bean);
    }

    public String toString() {
        return this.bean.toString();
    }

    public DynaBean clone() {
        try {
            return (DynaBean)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException(e);
        }
    }
}

