/*
 * Decompiled with CFR 0.152.
 */
package cn.ujava.common.bean.copier;

import cn.ujava.common.bean.BeanUtil;
import cn.ujava.common.bean.PropDesc;
import cn.ujava.common.bean.copier.AbsCopier;
import cn.ujava.common.bean.copier.CopyOptions;
import cn.ujava.common.lang.Assert;
import cn.ujava.common.lang.mutable.MutableEntry;
import cn.ujava.common.reflect.TypeUtil;
import java.lang.reflect.Type;
import java.util.Map;

public class BeanToBeanCopier<S, T>
extends AbsCopier<S, T> {
    private final Type targetType;

    public BeanToBeanCopier(S source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        Map<String, PropDesc> sourcePropDescMap = BeanUtil.getBeanDesc(this.source.getClass()).getPropMap(this.copyOptions.ignoreCase);
        sourcePropDescMap.forEach((sFieldName, sDesc) -> {
            if (null == sFieldName || !sDesc.isReadable(this.copyOptions.transientSupport)) {
                return;
            }
            Object sValue = sDesc.getValue(this.source);
            if (!this.copyOptions.testPropertyFilter(sDesc.getField(), sValue)) {
                return;
            }
            MutableEntry<String, Object> entry = this.copyOptions.editField((String)sFieldName, sValue);
            if (null == entry) {
                return;
            }
            sFieldName = entry.getKey();
            if (null == sFieldName) {
                return;
            }
            sValue = entry.getValue();
            PropDesc tDesc = (PropDesc)targetPropDescMap.get(sFieldName);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeUtil.getActualType(this.targetType, tDesc.getFieldType());
            sValue = this.copyOptions.convertField(fieldType, sValue);
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

